/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.BitsPerComponentBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ChannelDefinitionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CodestreamHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourSpecificationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ComponentMappingBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.CompositingLayerHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.FileTypeBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ImageHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.JP2HeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Parser;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.PaletteBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ReaderRequirementsBox;
import com.adobe.internal.pdftoolkit.services.pdfa2.ColorSpaceContainer;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractXObjectErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorICCProfileVersion3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorICCProfileVersion5OrNewer;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorICCProfileVersionOlderThan2;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000FileInvalid;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasColourChannlesWithDifferentBitDepths;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasInvalidColourSpecificationMethod;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasInvalidICCProfile;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasInvalidNumberOfColourChannels;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasMultipleColourSpecificationsButNoApproxSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasMultipleColourSpecificationsWithApproxOne;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000HasNumberofColorChannelsInconsistentWithCSFromImageDict;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000ImageUsesBitDepthBelow1;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000ImageUsesBitDepthGreaterThan38;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000UsesDeviceDependentColourSpace;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2XObjectErrorJpeg2000UsesInvalidEnumeratedColourSpace;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Jpeg2000ImageProcessor {
    private static final long[] validEnumeratedColorSpaces = new long[]{12L, 14L, 16L, 17L, 21L, 18L, 20L, 24L};
    private int objectNumber = 0;
    private int genNumber = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processJpeg2000Stream(InputByteStream jpeg2000Stream, DocumentProcessor docProcessor, boolean defaultGraySet, boolean defaultRGBSet, boolean defaultCMYKSet, PDFColorSpace csFromImageDict, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFXObjectImage image, PDFResources resources, ArrayList<GState> gStates) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        Jpeg2000BoxesList<Jpeg2000Box> topLevelBoxes = null;
        InputStream imageStream = null;
        InputStream decodedImageData = null;
        try {
            Jpeg2000BoxesList<Jpeg2000Box> requiredBoxesList;
            topLevelBoxes = Jpeg2000Parser.parse(jpeg2000Stream);
            JP2HeaderBox jp2HeaderBox = null;
            CompositingLayerHeaderBox firstCompositingLayerHeaderBox = null;
            CodestreamHeaderBox firstCodestreamHeaderBox = null;
            ReaderRequirementsBox readerRequirementsBox = null;
            FileTypeBox fileTypeBox = null;
            block66: for (int i = 0; i < topLevelBoxes.size(); ++i) {
                switch (((Jpeg2000Box)topLevelBoxes.get(i)).getBoxInfo().getType()) {
                    case jp2HeaderBox: {
                        jp2HeaderBox = (JP2HeaderBox)topLevelBoxes.get(i);
                        continue block66;
                    }
                    case compositingLayerHeaderBox: {
                        if (firstCompositingLayerHeaderBox != null) continue block66;
                        firstCompositingLayerHeaderBox = (CompositingLayerHeaderBox)topLevelBoxes.get(i);
                        continue block66;
                    }
                    case codestreamHeaderBox: {
                        if (firstCodestreamHeaderBox != null) continue block66;
                        firstCodestreamHeaderBox = (CodestreamHeaderBox)topLevelBoxes.get(i);
                        continue block66;
                    }
                    case readerRequirementsBox: {
                        readerRequirementsBox = (ReaderRequirementsBox)topLevelBoxes.get(i);
                        continue block66;
                    }
                    case fileTypeBox: {
                        fileTypeBox = (FileTypeBox)topLevelBoxes.get(i);
                        continue block66;
                    }
                }
            }
            this.objectNumber = image.getCosObject().getObjNum();
            this.genNumber = image.getCosObject().getObjGen();
            if (readerRequirementsBox != null) {
                ArrayList<Long> compatibilityList;
                if (fileTypeBox == null) {
                    errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000FileInvalid(this.objectNumber, this.genNumber));
                }
                if ((compatibilityList = fileTypeBox.getCompatibilityList()) != null && !compatibilityList.contains(Long.valueOf("6a707862", 16))) {
                    errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000FileInvalid(this.objectNumber, this.genNumber));
                }
            }
            if (!this.validateJpeg2000Boxes(requiredBoxesList = Jpeg2000Parser.getRequiredBoxesList(firstCompositingLayerHeaderBox, firstCodestreamHeaderBox, jp2HeaderBox), docProcessor, defaultGraySet, defaultRGBSet, defaultCMYKSet, csFromImageDict, errorCodes, validationOptions, validationHandler, conversionOptions, conversionHandler, resources, gStates)) {
                boolean bl = false;
                return bl;
            }
            PDFFilterList jpxDecodeReplacementFilterList = null;
            if (errorCodes.hasErrors() && conversionHandler != null && (jpxDecodeReplacementFilterList = conversionOptions.getJPXDecodeReplacementFilterList()) != null) {
                int numberOfColorComponents;
                int bitDepth;
                ImageFilterInterface.ImageInfo imageInfo;
                CustomFilterRegistry filterRegistry = image.getPDFDocument().getCosDocument().getOptions().getCustomFilterRegistry();
                CustomDecodeFilter registeredJPXDecodeFilter = null;
                if (filterRegistry != null && (registeredJPXDecodeFilter = filterRegistry.getRegisteredDecodeFilterByName(ASName.k_JPXDecode)) instanceof ImageFilterInterface && (imageInfo = ((ImageFilterInterface)registeredJPXDecodeFilter).getImageInfo(imageStream = image.getCosStream().getStreamEncoded().toInputStream())) != null && (bitDepth = imageInfo.getBitDepth()) > 0 && (numberOfColorComponents = imageInfo.getNumberOfColorComponents()) > 0) {
                    FilterParams filterParams = new FilterParams();
                    filterParams.put("BitsPerComponent", bitDepth);
                    filterParams.put("Components", numberOfColorComponents);
                    ColorSpaceContainer colorSpaceContainer = new ColorSpaceContainer();
                    if (!conversionHandler.getColorSpaceBasedOnColorComponents(numberOfColorComponents, colorSpaceContainer)) {
                        boolean bl = false;
                        return bl;
                    }
                    PDFColorSpace colorSpace = colorSpaceContainer.getColorSpace();
                    imageStream = image.getCosStream().getStreamEncoded().toInputStream();
                    if (colorSpace != null && (decodedImageData = ((ImageFilterInterface)registeredJPXDecodeFilter).decode(imageStream, filterParams)) != null) {
                        image.setBitsPerComponent(bitDepth);
                        image.setColorSpace(colorSpace);
                        image.setStreamData(decodedImageData);
                        image.setOutputFilters(jpxDecodeReplacementFilterList);
                        if (!conversionHandler.jpxDecodeFilterReplaced(errorCodes, jpxDecodeReplacementFilterList)) {
                            boolean bl = false;
                            return bl;
                        }
                        errorCodes.removeAllErrorCodes();
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (CustomFilterException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                try {
                    if (topLevelBoxes != null) {
                        topLevelBoxes.close();
                    }
                }
                finally {
                    try {
                        if (imageStream != null) {
                            imageStream.close();
                        }
                    }
                    finally {
                        if (decodedImageData != null) {
                            decodedImageData.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    private boolean validateJpeg2000Boxes(Jpeg2000BoxesList<Jpeg2000Box> requiredBoxesList, DocumentProcessor docProcessor, boolean defaultGraySet, boolean defaultRGBSet, boolean defaultCMYKSet, PDFColorSpace csFromImageDict, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFResources resources, ArrayList<GState> gStates) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ChannelDefinitionBox channelDefinitionBox = null;
        Jpeg2000BoxesList<ColourSpecificationBox> csBoxesList = new Jpeg2000BoxesList<ColourSpecificationBox>();
        ImageHeaderBox imageHeaderBox = null;
        BitsPerComponentBox bitsPerComponentBox = null;
        ComponentMappingBox componentMappingBox = null;
        PaletteBox paletteBox = null;
        block8: for (int i = 0; i < requiredBoxesList.size(); ++i) {
            switch (((Jpeg2000Box)requiredBoxesList.get(i)).getBoxInfo().getType()) {
                case channelDefinitionBox: {
                    channelDefinitionBox = (ChannelDefinitionBox)requiredBoxesList.get(i);
                    continue block8;
                }
                case colourSpecificationBox: {
                    csBoxesList.add((ColourSpecificationBox)requiredBoxesList.get(i));
                    continue block8;
                }
                case imageHeaderBox: {
                    imageHeaderBox = (ImageHeaderBox)requiredBoxesList.get(i);
                    continue block8;
                }
                case bitsPerComponentBox: {
                    bitsPerComponentBox = (BitsPerComponentBox)requiredBoxesList.get(i);
                    continue block8;
                }
                case componentMappingBox: {
                    componentMappingBox = (ComponentMappingBox)requiredBoxesList.get(i);
                    continue block8;
                }
                case paletteBox: {
                    paletteBox = (PaletteBox)requiredBoxesList.get(i);
                    continue block8;
                }
            }
        }
        ArrayList<Integer> colourChannelsIndices = this.validateColourSpecificationRelatedInfo(channelDefinitionBox, csBoxesList, docProcessor, defaultGraySet, defaultRGBSet, defaultCMYKSet, csFromImageDict, errorCodes, validationOptions, validationHandler, conversionOptions, conversionHandler, resources, gStates);
        if (colourChannelsIndices == null) {
            return false;
        }
        this.validateBitDepths(colourChannelsIndices, imageHeaderBox, paletteBox, bitsPerComponentBox, componentMappingBox, errorCodes);
        return true;
    }

    private ArrayList<Integer> validateColourSpecificationRelatedInfo(ChannelDefinitionBox channelDefinitionBox, Jpeg2000BoxesList<ColourSpecificationBox> csBoxesList, DocumentProcessor docProcessor, boolean defaultGraySet, boolean defaultRGBSet, boolean defaultCMYKSet, PDFColorSpace csFromImageDict, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFResources resources, ArrayList<GState> gStates) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Integer> colourChannelsIndices = new ArrayList<Integer>();
        int numberOfColourChannels = 0;
        ColourSpecificationBox csBoxWithApproxSet = null;
        if (channelDefinitionBox != null) {
            int[] channelTypesList = channelDefinitionBox.getChannelTypeList();
            for (int i = 0; i < channelDefinitionBox.getNumberOfChannelDecriptions(); ++i) {
                if (channelTypesList[i] == 0) {
                    ++numberOfColourChannels;
                }
                colourChannelsIndices.add(channelDefinitionBox.getChannelIndicesList()[i]);
            }
            if (numberOfColourChannels != 1 && numberOfColourChannels != 3 && numberOfColourChannels != 4) {
                errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasInvalidNumberOfColourChannels(numberOfColourChannels, this.objectNumber, this.genNumber));
            }
        } else {
            numberOfColourChannels = -1;
        }
        for (int i = 0; i < csBoxesList.size(); ++i) {
            if (((ColourSpecificationBox)csBoxesList.get(i)).getApprox() != 1) continue;
            if (csBoxWithApproxSet == null) {
                csBoxWithApproxSet = (ColourSpecificationBox)csBoxesList.get(i);
                continue;
            }
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasMultipleColourSpecificationsWithApproxOne(this.objectNumber, this.genNumber));
            return colourChannelsIndices;
        }
        if (csBoxesList.size() > 1 && csBoxWithApproxSet == null) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasMultipleColourSpecificationsButNoApproxSet(this.objectNumber, this.genNumber));
            return colourChannelsIndices;
        }
        if (csBoxesList.size() == 1) {
            csBoxWithApproxSet = (ColourSpecificationBox)csBoxesList.get(0);
        }
        if (numberOfColourChannels == -1 && (numberOfColourChannels = Jpeg2000Parser.getNumberOfColorChannels(csBoxWithApproxSet)) != 1 && numberOfColourChannels != 3 && numberOfColourChannels != 4) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasInvalidNumberOfColourChannels(numberOfColourChannels, this.objectNumber, this.genNumber));
        }
        if (csFromImageDict != null) {
            this.validateCSFromImageDictConsistentencyWithNumberOfColorChannels(numberOfColourChannels, csFromImageDict, errorCodes);
            int method = csBoxWithApproxSet.getSpecificationMethod();
            if (method != 1 && method != 2 && method != 3) {
                errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasInvalidColourSpecificationMethod(method, this.objectNumber, this.genNumber));
            }
        } else if (!this.validateMethodAndColourSpace(csBoxWithApproxSet, numberOfColourChannels, docProcessor, defaultGraySet, defaultRGBSet, defaultCMYKSet, errorCodes, validationOptions, validationHandler, conversionOptions, conversionHandler, resources, gStates)) {
            return null;
        }
        return colourChannelsIndices;
    }

    private void validateCSFromImageDictConsistentencyWithNumberOfColorChannels(int numberOfColourChannels, PDFColorSpace csFromImageDict, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (csFromImageDict.getNumberOfComponents() != numberOfColourChannels) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasNumberofColorChannelsInconsistentWithCSFromImageDict(csFromImageDict.getName().asString(), numberOfColourChannels, this.objectNumber, this.genNumber));
        }
    }

    private boolean validateMethodAndColourSpace(ColourSpecificationBox csBoxWithApproxSet, int numberOfColourChannels, DocumentProcessor docProcessor, boolean defaultGraySet, boolean defaultRGBSet, boolean defaultCMYKSet, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFResources resources, ArrayList<GState> gStates) throws IOException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int method = csBoxWithApproxSet.getSpecificationMethod();
        boolean usesValidColorSpace = true;
        if (method == 1) {
            long enumeratedCS = csBoxWithApproxSet.getEnumeratedColourSpace();
            if (!Jpeg2000ImageProcessor.isValidEnumeratedColourSpace(enumeratedCS)) {
                errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000UsesInvalidEnumeratedColourSpace(enumeratedCS, this.objectNumber, this.genNumber));
                usesValidColorSpace = false;
            }
        } else if (method == 2 || method == 3) {
            InputByteStream iccProfile = csBoxWithApproxSet.getICCProfile();
            if (iccProfile != null) {
                ICC_Profile icc_Profile = ICC_Profile.getInstance(iccProfile.toInputStream());
                PDFA2AbstractXObjectErrorCode versionErrorCode = null;
                String profileVersion = String.valueOf(icc_Profile.getMajorVersion()) + "." + String.valueOf(icc_Profile.getMinorVersion());
                versionErrorCode = ColorSpaceProcessor.isICCProfileVersionAllowed(icc_Profile, new PDFA2XObjectErrorICCProfileVersion5OrNewer(profileVersion, this.objectNumber, this.genNumber), new PDFA2XObjectErrorICCProfileVersionOlderThan2(profileVersion, this.objectNumber, this.genNumber), new PDFA2XObjectErrorICCProfileVersion3(this.objectNumber, this.genNumber));
                if (versionErrorCode != null) {
                    errorCodes.addErrorCode(versionErrorCode);
                    usesValidColorSpace = false;
                }
            } else {
                errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasInvalidICCProfile(this.objectNumber, this.genNumber));
                usesValidColorSpace = false;
            }
        } else {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasInvalidColourSpecificationMethod(method, this.objectNumber, this.genNumber));
        }
        return usesValidColorSpace || this.processJpeg2000DeviceDependentColorSpace(numberOfColourChannels, docProcessor, errorCodes, validationHandler, conversionOptions, conversionHandler, resources, gStates);
    }

    private void validateBitDepths(ArrayList<Integer> colourChannelsIndices, ImageHeaderBox imageHeaderBox, PaletteBox paletteBox, BitsPerComponentBox bitsPerComponentBox, ComponentMappingBox componentMappingBox, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes) throws IOException {
        this.validateBitDepthValuesRange(imageHeaderBox, bitsPerComponentBox, errorCodes);
        this.validateColourChannelsBitDepthsEquality(colourChannelsIndices, paletteBox, bitsPerComponentBox, componentMappingBox, errorCodes);
    }

    private void validateColourChannelsBitDepthsEquality(ArrayList<Integer> colourChannelsIndices, PaletteBox paletteBox, BitsPerComponentBox bitsPerComponentBox, ComponentMappingBox componentMappingBox, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes) throws IOException {
        block8: {
            ArrayList<Byte> bitDepthsFromBitsPerComponentBox;
            byte baseBitDepth;
            byte bitDepth;
            block9: {
                bitDepth = 0;
                baseBitDepth = -1;
                if (colourChannelsIndices.isEmpty()) {
                    return;
                }
                bitDepthsFromBitsPerComponentBox = null;
                if (bitsPerComponentBox != null) {
                    bitDepthsFromBitsPerComponentBox = bitsPerComponentBox.getBitDepthsList();
                }
                if (componentMappingBox != null || bitDepthsFromBitsPerComponentBox == null) break block9;
                baseBitDepth = (byte)(bitDepthsFromBitsPerComponentBox.get(colourChannelsIndices.get(0)) + 1);
                for (int i = 1; i < colourChannelsIndices.size(); ++i) {
                    bitDepth = (byte)(bitDepthsFromBitsPerComponentBox.get(colourChannelsIndices.get(i)) + 1);
                    if (bitDepth == baseBitDepth) continue;
                    errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasColourChannlesWithDifferentBitDepths(this.objectNumber, this.genNumber));
                    break block8;
                }
                break block8;
            }
            if (componentMappingBox == null) break block8;
            int mtyp = 0;
            int pcol = 0;
            baseBitDepth = -1;
            for (int i = 0; i < colourChannelsIndices.size(); ++i) {
                mtyp = componentMappingBox.getMTYPList().get(colourChannelsIndices.get(i));
                if (mtyp == 0 && bitDepthsFromBitsPerComponentBox != null) {
                    bitDepth = (byte)(bitDepthsFromBitsPerComponentBox.get(colourChannelsIndices.get(i)) + 1);
                    if (baseBitDepth == -1) {
                        baseBitDepth = bitDepth;
                        continue;
                    }
                    if (bitDepth == baseBitDepth) continue;
                    errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasColourChannlesWithDifferentBitDepths(this.objectNumber, this.genNumber));
                } else {
                    if (mtyp != 1 || paletteBox == null) continue;
                    pcol = componentMappingBox.getPCOLList().get(colourChannelsIndices.get(i));
                    bitDepth = (byte)(paletteBox.getBitDepths()[pcol] + 1);
                    if (baseBitDepth == -1) {
                        baseBitDepth = bitDepth;
                        continue;
                    }
                    if (bitDepth == baseBitDepth) continue;
                    errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000HasColourChannlesWithDifferentBitDepths(this.objectNumber, this.genNumber));
                }
                break;
            }
        }
    }

    private void validateBitDepthValuesRange(ImageHeaderBox imageHeaderBox, BitsPerComponentBox bitsPerComponentBox, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes) throws IOException {
        if (bitsPerComponentBox == null) {
            this.isBitDepthInRange(imageHeaderBox.getBitsPerComponent(), errorCodes);
        } else {
            ArrayList<Byte> bitDepths = bitsPerComponentBox.getBitDepthsList();
            for (int i = 0; i < bitDepths.size() && this.isBitDepthInRange(bitDepths.get(i), errorCodes); ++i) {
            }
        }
    }

    private boolean isBitDepthInRange(byte bitDepth, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes) {
        byte actualBitDepth = (byte)(bitDepth + 1);
        if (actualBitDepth > 38) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000ImageUsesBitDepthGreaterThan38(actualBitDepth, this.objectNumber, this.genNumber));
            return false;
        }
        if (actualBitDepth < 1) {
            errorCodes.addErrorCode(new PDFA2XObjectErrorJpeg2000ImageUsesBitDepthBelow1(actualBitDepth, this.objectNumber, this.genNumber));
            return false;
        }
        return true;
    }

    private boolean processJpeg2000DeviceDependentColorSpace(long numberOfColorChannels, DocumentProcessor docProcessor, PDFA2ErrorSet<PDFA2AbstractXObjectErrorCode> errorCodes, TrackingValidationHandler validationHandler, PDFA2ConversionOptions conversionOptions, TrackingConversionHandler conversionHandler, PDFResources resources, ArrayList<GState> gStates) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return !(numberOfColorChannels == 1L ? !ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, new PDFA2XObjectErrorJpeg2000UsesDeviceDependentColourSpace(ASName.k_DeviceGray.asString(), this.objectNumber, this.genNumber), ASName.k_DefaultGray, gStates) : (numberOfColorChannels == 3L ? !ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, new PDFA2XObjectErrorJpeg2000UsesDeviceDependentColourSpace(ASName.k_DeviceRGB.asString(), this.objectNumber, this.genNumber), ASName.k_DefaultRGB, gStates) : numberOfColorChannels == 4L && !ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, new PDFA2XObjectErrorJpeg2000UsesDeviceDependentColourSpace(ASName.k_DeviceCMYK.asString(), this.objectNumber, this.genNumber), ASName.k_DefaultCMYK, gStates)));
    }

    private static boolean isValidEnumeratedColourSpace(long enumeratedCS) {
        for (int i = 0; i < validEnumeratedColorSpaces.length; ++i) {
            if (validEnumeratedColorSpaces[i] != enumeratedCS) continue;
            return true;
        }
        return false;
    }
}

