/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceN;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpacePattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceSeparation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.interchange.metadata.PDFMetadata;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.services.pdfa.common.ColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceDeviceNAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceIndexedAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceMapAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFColorSpaceSeparationAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2XMPErrorCollector;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractColorSpaceErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorAlternateCSNotDeviceIndependent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorColorantNameNotValidUTF8;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorDeviceNAlternateSpaceOrTintTransformNotConsistentWithSeparationArray;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorDeviceNHasMoreThan32Colourants;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorDeviceNSpotColorNotPresentInColorantsDict;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorICCBasedCMYKUsedWithOPMSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorICCProfileVersion3;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorICCProfileVersion5OrNewer;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorICCProfileVersionOlderThan2;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorIccProfileCouldNotBeParsed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorNotDeviceIndependent;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GState;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.GStateRegionInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.PDFA2FailFastValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.SharedConstraints;
import com.adobe.internal.pdftoolkit.services.pdfa2.processor.TrackingValidationHandler;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ColorSpaceProcessor {
    ColorSpaceProcessor() {
    }

    static boolean process(PDFResources resources, LinkedHashMap<ASName, ArrayList<GState>> referencedColorSpaces, DocumentProcessor docProcessor, PDFA2ConformanceLevel conformance, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, PDFA2ValidationOptions validationOptions, TrackingValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFColorSpaceMap colorSpaceMap = resources.getColorSpaceMap();
        if (colorSpaceMap == null || colorSpaceMap.isEmpty()) {
            return true;
        }
        if (referencedColorSpaces == null || referencedColorSpaces.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<ASName, ArrayList<GState>>> entriesItr = referencedColorSpaces.entrySet().iterator();
        Map.Entry<ASName, ArrayList<GState>> entry = null;
        ASName colorSpaceName = null;
        ArrayList<GState> gStates = null;
        while (entriesItr.hasNext()) {
            entry = entriesItr.next();
            colorSpaceName = entry.getKey();
            gStates = entry.getValue();
            PDFColorSpaceMapAdapter csAdapter = new PDFColorSpaceMapAdapter(colorSpaceMap, colorSpaceName);
            if (ColorSpaceProcessor.process(csAdapter, colorSpaceName, colorSpaceMap.get(colorSpaceName), docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates)) continue;
            return false;
        }
        return true;
    }

    static boolean process(ColorSpaceAdapter csAdapter, ASName name, PDFColorSpace colorSpace, DocumentProcessor docProcessor, TrackingValidationHandler validationHandler, PDFResources resources, PDFA2ConversionOptions conversionOptions, PDFA2ConversionHandler conversionHandler, ArrayList<GState> gStates) throws PDFIOException, PDFSecurityException {
        PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorCodes;
        block37: {
            if (colorSpace == null) {
                return true;
            }
            if (!validationHandler.beginColorSpaceScan(name, colorSpace)) {
                return false;
            }
            errorCodes = new PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode>();
            int objectNumber = colorSpace.getCosObject().getObjNum();
            int genNumber = colorSpace.getCosObject().getObjGen();
            try {
                PDFColorSpacePattern patternCS;
                PDFColorSpace baseCS;
                if (colorSpace instanceof PDFColorSpaceDeviceRGB) {
                    PDFA2AbstractColorSpaceErrorCode errorCode = null;
                    errorCode = name == ASName.k_Alternate ? new PDFA2ColorSpaceErrorAlternateCSNotDeviceIndependent(ASName.k_DeviceRGB.toString(), objectNumber, genNumber) : new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceRGB.toString(), objectNumber, genNumber);
                    if (!ColorSpaceProcessor.colorSpaceNeedsProcessing(name, colorSpace)) {
                        errorCodes.addErrorCode(new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceRGB.toString(), colorSpace.getCosObject().getObjNum(), genNumber));
                    } else if (!ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, errorCode, ASName.k_DefaultRGB, gStates)) {
                        return false;
                    }
                    break block37;
                }
                if (colorSpace instanceof PDFColorSpaceDeviceCMYK) {
                    PDFA2AbstractColorSpaceErrorCode errorCode = null;
                    errorCode = name == ASName.k_Alternate ? new PDFA2ColorSpaceErrorAlternateCSNotDeviceIndependent(ASName.k_DeviceCMYK.toString(), objectNumber, genNumber) : new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceCMYK.toString(), objectNumber, genNumber);
                    if (!ColorSpaceProcessor.colorSpaceNeedsProcessing(name, colorSpace)) {
                        errorCodes.addErrorCode(new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceCMYK.toString(), colorSpace.getCosObject().getObjNum(), genNumber));
                    } else if (!ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, errorCode, ASName.k_DefaultCMYK, gStates)) {
                        return false;
                    }
                    break block37;
                }
                if (colorSpace instanceof PDFColorSpaceDeviceGray) {
                    PDFA2AbstractColorSpaceErrorCode errorCode = null;
                    errorCode = name == ASName.k_Alternate ? new PDFA2ColorSpaceErrorAlternateCSNotDeviceIndependent(ASName.k_DeviceGray.toString(), objectNumber, genNumber) : new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceGray.toString(), objectNumber, genNumber);
                    if (!ColorSpaceProcessor.colorSpaceNeedsProcessing(name, colorSpace)) {
                        errorCodes.addErrorCode(new PDFA2ColorSpaceErrorNotDeviceIndependent(ASName.k_DeviceGray.toString(), colorSpace.getCosObject().getObjNum(), genNumber));
                    } else if (!ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, errorCode, ASName.k_DefaultGray, gStates)) {
                        return false;
                    }
                    break block37;
                }
                if (colorSpace instanceof PDFColorSpaceICCBased) {
                    PDFICCProfile replacementProfile;
                    PDFColorSpaceICCBased iccCS = (PDFColorSpaceICCBased)colorSpace;
                    if (gStates != null && !gStates.isEmpty()) {
                        Iterator<GState> gStatesItr = gStates.iterator();
                        while (gStatesItr.hasNext()) {
                            try {
                                GState gstate = gStatesItr.next();
                                if (ColorSpaceProcessor.validateCurrentCSWithCurrentOPM(gstate.isOverPrintStrokeOrFillSet(), gstate.getCurrentOPMValue(), iccCS)) continue;
                                errorCodes.addErrorCode(new PDFA2ColorSpaceErrorICCBasedCMYKUsedWithOPMSet(objectNumber, genNumber));
                                break;
                            }
                            catch (PDFInvalidContentException e) {
                                errorCodes.addErrorCode(new PDFA2ColorSpaceErrorPDFGeneralFailure(objectNumber, genNumber));
                                break;
                            }
                        }
                    }
                    PDFICCProfile profile = iccCS.getPDFICCProfile();
                    String profileVersion = "";
                    try {
                        ICC_ColorSpace icc_CS = (ICC_ColorSpace)profile.getColorSpace();
                        ICC_Profile iccProfile = icc_CS.getProfile();
                        profileVersion = String.valueOf(iccProfile.getMajorVersion()) + "." + String.valueOf(iccProfile.getMinorVersion());
                    }
                    catch (PDFInvalidContentException e) {
                        int iccObjectNumber = profile.getCosObject().getObjNum();
                        int iccGenNumber = profile.getCosObject().getObjGen();
                        PDFColorSpace alternate = iccCS.getAlternateColorSpace();
                        if (alternate == null || csAdapter == null || conversionHandler == null) {
                            errorCodes.addErrorCode(new PDFA2ColorSpaceErrorIccProfileCouldNotBeParsed(iccObjectNumber, iccGenNumber));
                        }
                        PDFA2FailFastValidationHandler failFastValidationHandler = new PDFA2FailFastValidationHandler();
                        if (ColorSpaceProcessor.process(csAdapter, name, alternate, docProcessor, new TrackingValidationHandler(failFastValidationHandler), resources, conversionOptions, conversionHandler, gStates)) {
                            if (csAdapter.setColorSpace(alternate)) {
                                return conversionHandler.alternateColorSpaceUsedAsInvalidICCProfileFound(iccCS);
                            }
                            errorCodes.addErrorCode(new PDFA2ColorSpaceErrorIccProfileCouldNotBeParsed(iccObjectNumber, iccGenNumber));
                        }
                        errorCodes.addErrorCode(new PDFA2ColorSpaceErrorIccProfileCouldNotBeParsed(iccObjectNumber, iccGenNumber));
                    }
                    boolean continueProcessing = ColorSpaceProcessor.processIccProfile(profile, new PDFA2ColorSpaceErrorICCProfileVersion5OrNewer(profileVersion, objectNumber, genNumber), new PDFA2ColorSpaceErrorICCProfileVersionOlderThan2(profileVersion, objectNumber, genNumber), new PDFA2ColorSpaceErrorICCProfileVersion3(objectNumber, genNumber), errorCodes, docProcessor, validationHandler, null, true);
                    if ((errorCodes.errorCodeSet(PDFA2ColorSpaceErrorICCProfileVersion5OrNewer.class) || errorCodes.errorCodeSet(PDFA2ColorSpaceErrorICCProfileVersionOlderThan2.class) || errorCodes.errorCodeSet(PDFA2ColorSpaceErrorICCProfileVersion3.class)) && conversionHandler != null && (replacementProfile = conversionHandler.getValidICCProfile(profile)) != null) {
                        iccCS.setPDFICCProfile(replacementProfile);
                        errorCodes.unSetErrorCode(PDFA2ColorSpaceErrorICCProfileVersion5OrNewer.class);
                        errorCodes.unSetErrorCode(PDFA2ColorSpaceErrorICCProfileVersionOlderThan2.class);
                        errorCodes.unSetErrorCode(PDFA2ColorSpaceErrorICCProfileVersion3.class);
                    }
                    if (!continueProcessing) {
                        return false;
                    }
                    break block37;
                }
                if (colorSpace instanceof PDFColorSpaceSeparation) {
                    ColorSpaceProcessor.processSeparationColorSpace(name, (PDFColorSpaceSeparation)colorSpace, errorCodes, docProcessor, validationHandler, conversionHandler, conversionOptions, resources, gStates);
                } else if (colorSpace instanceof PDFColorSpaceDeviceN) {
                    ColorSpaceProcessor.processDeviceNColorSpace(name, (PDFColorSpaceDeviceN)colorSpace, errorCodes, docProcessor, validationHandler, conversionHandler, conversionOptions, resources, gStates);
                } else if (colorSpace instanceof PDFColorSpaceIndexed) {
                    PDFColorSpaceIndexed indCS = (PDFColorSpaceIndexed)colorSpace;
                    PDFColorSpace baseCS2 = indCS.getBaseColorSpace();
                    if (ColorSpaceProcessor.colorSpaceNeedsProcessing(name, baseCS2)) {
                        ColorSpaceProcessor.process(new PDFColorSpaceIndexedAdapter(indCS), ASName.k_Base, baseCS2, docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates);
                    }
                } else if (colorSpace instanceof PDFColorSpacePattern && ColorSpaceProcessor.colorSpaceNeedsProcessing(name, baseCS = (patternCS = (PDFColorSpacePattern)colorSpace).getPatternColorSpace())) {
                    ColorSpaceProcessor.process(null, ASName.k_Base, baseCS, docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates);
                }
            }
            catch (PDFInvalidDocumentException e) {
                errorCodes.addErrorCode(new PDFA2ColorSpaceErrorPDFGeneralFailure(colorSpace.getCosObject().getObjNum(), genNumber));
            }
        }
        if (errorCodes.hasErrors() && !validationHandler.colorSpaceError(errorCodes)) {
            return false;
        }
        return validationHandler.endColorSpaceScan();
    }

    private static boolean colorSpaceNeedsProcessing(ASName currentCSName, PDFColorSpace colorSpaceToProcess) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFColorSpace underlyingColorSpace = ColorSpaceProcessor.getUnderLyingColorSpaceToValidate(colorSpaceToProcess);
        return !(currentCSName == ASName.k_DefaultRGB && underlyingColorSpace instanceof PDFColorSpaceDeviceRGB || currentCSName == ASName.k_DefaultCMYK && underlyingColorSpace instanceof PDFColorSpaceDeviceCMYK || currentCSName == ASName.k_DefaultGray && underlyingColorSpace instanceof PDFColorSpaceDeviceGray);
    }

    private static void processDeviceNColorSpace(ASName currentCSName, PDFColorSpaceDeviceN deviceNCS, PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorSet, DocumentProcessor docProcessor, TrackingValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFResources resources, ArrayList<GState> gStates) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (deviceNCS.getCosArray().size() < 4) {
            throw new PDFInvalidDocumentException(deviceNCS.getCosObject().getObjNum() + " is not a valid DeviceN color space.");
        }
        PDFColorSpace alternateCS = deviceNCS.getAlternateColorSpace();
        if (ColorSpaceProcessor.colorSpaceNeedsProcessing(currentCSName, alternateCS)) {
            ColorSpaceProcessor.process(new PDFColorSpaceDeviceNAdapter(deviceNCS), ASName.k_Alternate, alternateCS, docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates);
        }
        if (conversionHandler == null) {
            ColorSpaceProcessor.validateColorantsDictionary(deviceNCS, errorSet, docProcessor);
        }
    }

    private static void validateColorantsDictionary(PDFColorSpaceDeviceN deviceNCS, PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorSet, DocumentProcessor docProcessor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int objectNumber = deviceNCS.getCosObject().getObjNum();
        int genNumber = deviceNCS.getCosObject().getObjGen();
        ASName[] colorantNames = deviceNCS.getColorantNames();
        if (colorantNames != null) {
            if (colorantNames.length > 32) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNHasMoreThan32Colourants(colorantNames.length, objectNumber, genNumber));
            }
            for (int i = 0; i < colorantNames.length; ++i) {
                if (ColorSpaceProcessor.isColorantNameValidUTF8(colorantNames[i])) continue;
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorColorantNameNotValidUTF8(colorantNames[i] != null ? colorantNames[i].toString() : null, objectNumber, genNumber));
                break;
            }
        }
        if (deviceNCS.getCosArray().size() > 4) {
            CosObject attrs = deviceNCS.getCosArray().get(4);
            if (!(attrs instanceof CosDictionary)) {
                throw new PDFInvalidDocumentException("DeviceN colorspace array is invalid");
            }
            CosDictionary attrsDict = (CosDictionary)attrs;
            CosDictionary colorantsDict = attrsDict.getCosDictionary(ASName.k_Colorants);
            if ((colorantNames = ColorSpaceProcessor.keepOnlySpotColorForValidation(colorantNames)) != null && colorantNames.length != 0 && colorantsDict == null) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNSpotColorNotPresentInColorantsDict(objectNumber, genNumber));
                return;
            }
            if (colorantsDict != null) {
                ColorSpaceProcessor.validateDeviceNSeparationArrays(deviceNCS, colorantsDict, errorSet, docProcessor);
            }
            if (colorantNames == null || colorantNames.length == 0) {
                return;
            }
            for (int i = 0; i < colorantNames.length; ++i) {
                if (colorantsDict.containsKey(colorantNames[i])) continue;
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNSpotColorNotPresentInColorantsDict(objectNumber, genNumber));
            }
        } else if (colorantNames != null && colorantNames.length != 0) {
            errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNSpotColorNotPresentInColorantsDict(objectNumber, genNumber));
        }
    }

    private static ASName[] keepOnlySpotColorForValidation(ASName[] colorantNames) {
        HashSet<ASName> specialColorants = new HashSet<ASName>();
        specialColorants.add(ASName.create("All"));
        specialColorants.add(ASName.create("None"));
        specialColorants.add(ASName.create("Cyan"));
        specialColorants.add(ASName.create("Magenta"));
        specialColorants.add(ASName.create("Yellow"));
        specialColorants.add(ASName.create("Black"));
        ArrayList<ASName> cNames = new ArrayList<ASName>();
        if (colorantNames != null && colorantNames.length != 0) {
            for (int i = 0; i < colorantNames.length; ++i) {
                if (specialColorants.contains(colorantNames[i])) continue;
                cNames.add(colorantNames[i]);
            }
        }
        ASName[] names = new ASName[cNames.size()];
        for (int i = 0; i < cNames.size(); ++i) {
            names[i] = (ASName)cNames.get(i);
        }
        return names;
    }

    private static void validateDeviceNSeparationArrays(PDFColorSpaceDeviceN deviceNCS, CosDictionary colorantsDict, PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorSet, DocumentProcessor docProcessor) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        int objectNumber = deviceNCS.getCosObject().getObjNum();
        int genNumber = deviceNCS.getCosObject().getObjGen();
        Iterator<ASName> keyItr = colorantsDict.keyIterator();
        ASName colorantName = null;
        while (keyItr.hasNext()) {
            colorantName = keyItr.next();
            if (ColorSpaceProcessor.isColorantNameValidUTF8(colorantName)) continue;
            errorSet.addErrorCode(new PDFA2ColorSpaceErrorColorantNameNotValidUTF8(colorantName != null ? colorantName.toString() : null, objectNumber, genNumber));
        }
        CosContainerValuesIterator separationCSItr = colorantsDict.getValuesIterator();
        CosObject separationCS = null;
        PDFColorSpace altCSFromCurrentCS = deviceNCS.getAlternateColorSpace();
        CosObject tintTransformFromCurrentCS = deviceNCS.getCosArray().get(3);
        PDFColorSpace altCSFromArray = null;
        CosObject tintTransformFromArray = null;
        while (separationCSItr.hasNext()) {
            separationCS = separationCSItr.next().getValue();
            if (!(separationCS instanceof CosArray) || ((CosArray)separationCS).size() < 4) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorPDFGeneralFailure(objectNumber, genNumber));
                continue;
            }
            ColorSpaceProcessor.validateSeparationCSArraysConsistency(PDFColorSpaceSeparation.getInstance(separationCS), errorSet, docProcessor);
            altCSFromArray = PDFColorSpaceSeparation.getInstance(separationCS).getAlternateColorSpace();
            if (altCSFromArray != null) {
                if (!altCSFromArray.equals(altCSFromCurrentCS)) {
                    errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNAlternateSpaceOrTintTransformNotConsistentWithSeparationArray(objectNumber, genNumber));
                    return;
                }
            } else if (altCSFromCurrentCS != null && !altCSFromCurrentCS.equals(altCSFromArray)) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNAlternateSpaceOrTintTransformNotConsistentWithSeparationArray(objectNumber, genNumber));
                return;
            }
            if ((tintTransformFromArray = ((CosArray)separationCS).get(3)) != null) {
                if (tintTransformFromArray.equals(tintTransformFromCurrentCS)) continue;
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNAlternateSpaceOrTintTransformNotConsistentWithSeparationArray(objectNumber, genNumber));
                return;
            }
            if (tintTransformFromCurrentCS == null || tintTransformFromCurrentCS.equals(tintTransformFromArray)) continue;
            errorSet.addErrorCode(new PDFA2ColorSpaceErrorDeviceNAlternateSpaceOrTintTransformNotConsistentWithSeparationArray(objectNumber, genNumber));
            return;
        }
    }

    private static void processSeparationColorSpace(ASName currentCSName, PDFColorSpaceSeparation separationCS, PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorSet, DocumentProcessor docProcessor, TrackingValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFResources resources, ArrayList<GState> gStates) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName colorantName;
        if (separationCS.getCosArray().size() < 4) {
            throw new PDFInvalidDocumentException(separationCS.getCosObject().getObjNum() + " is not a valid separation color space.");
        }
        PDFColorSpace altCSFromCurrentCS = separationCS.getAlternateColorSpace();
        if (ColorSpaceProcessor.colorSpaceNeedsProcessing(currentCSName, altCSFromCurrentCS)) {
            ColorSpaceProcessor.process(new PDFColorSpaceSeparationAdapter(separationCS), ASName.k_Alternate, altCSFromCurrentCS, docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates);
        }
        if (!ColorSpaceProcessor.isColorantNameValidUTF8(colorantName = separationCS.getColorantName())) {
            errorSet.addErrorCode(new PDFA2ColorSpaceErrorColorantNameNotValidUTF8(colorantName != null ? colorantName.toString() : null, separationCS.getCosObject().getObjNum(), separationCS.getCosObject().getObjGen()));
        }
        ColorSpaceProcessor.validateSeparationCSArraysConsistency(separationCS, errorSet, docProcessor);
    }

    private static boolean isColorantNameValidUTF8(ASName colorantName) {
        if (colorantName == null) {
            return true;
        }
        return PDFText.isValidUTF8(colorantName.getBytes());
    }

    private static void validateSeparationCSArraysConsistency(PDFColorSpaceSeparation separationCS, PDFA2ErrorSet<PDFA2AbstractColorSpaceErrorCode> errorSet, DocumentProcessor docProcessor) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int objectNumber = separationCS.getCosObject().getObjNum();
        int genNumber = separationCS.getCosObject().getObjGen();
        Map<ASName, PDFColorSpaceSeparation> separationCSArrays = docProcessor.separationCSArrays;
        Set<ASName> inconsistentSeparationCSNames = docProcessor.inconsistentSeparationCSNames;
        ASName separationCSName = separationCS.getColorantName();
        if (inconsistentSeparationCSNames.contains(separationCSName)) {
            errorSet.addErrorCode(new PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform(objectNumber, genNumber));
            return;
        }
        if (separationCSArrays.containsKey(separationCSName)) {
            PDFColorSpaceSeparation value = separationCSArrays.get(separationCSName);
            PDFColorSpace altCSFromCurrentCS = separationCS.getAlternateColorSpace();
            PDFColorSpace altCSFromArray = value.getAlternateColorSpace();
            if (altCSFromArray != null) {
                if (!altCSFromArray.equals(altCSFromCurrentCS)) {
                    errorSet.addErrorCode(new PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform(objectNumber, genNumber));
                    inconsistentSeparationCSNames.add(separationCSName);
                    return;
                }
            } else if (altCSFromCurrentCS != null && !altCSFromCurrentCS.equals(altCSFromArray)) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform(objectNumber, genNumber));
                inconsistentSeparationCSNames.add(separationCSName);
                return;
            }
            CosObject tintTransformFromArray = value.getCosArray().get(3);
            CosObject tintTransformFromCurrentCS = separationCS.getCosArray().get(3);
            if (tintTransformFromArray != null) {
                if (!tintTransformFromArray.equals(tintTransformFromCurrentCS)) {
                    errorSet.addErrorCode(new PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform(objectNumber, genNumber));
                    inconsistentSeparationCSNames.add(separationCSName);
                    return;
                }
            } else if (tintTransformFromCurrentCS != null && !tintTransformFromCurrentCS.equals(tintTransformFromArray)) {
                errorSet.addErrorCode(new PDFA2ColorSpaceErrorSeparationArraysHaveDifferentAlternateSpaceOrTintTransform(objectNumber, genNumber));
                inconsistentSeparationCSNames.add(separationCSName);
            }
        } else {
            separationCSArrays.put(separationCSName, separationCS);
        }
    }

    static boolean hasPDFAOutputIntentWithRGBCS(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasPDFAOutputIntent(document, 5);
    }

    static boolean hasPDFAOutputIntentWithCMYKCS(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasPDFAOutputIntent(document, 9);
    }

    static boolean hasPDFAOutputIntent(PDFDocument document) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.hasPDFAOutputIntent(document, null);
    }

    private static boolean hasPDFAOutputIntent(PDFDocument document, Integer requiredColorSpaceType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOutputIntentsList intents = document.requireCatalog().getOutputIntents();
        if (intents == null) {
            return false;
        }
        for (PDFOutputIntent intent : intents) {
            ASName subtype = intent.getSubType();
            if (!subtype.equals(SharedConstraints.k_GTS_PDFA1)) continue;
            if (requiredColorSpaceType == null) {
                return true;
            }
            PDFICCProfile iccProfile = intent.getDestOutputProfile();
            if (iccProfile == null) {
                return false;
            }
            try {
                ColorSpace cs = iccProfile.getColorSpace();
                return cs.getType() == requiredColorSpaceType.intValue();
            }
            catch (PDFInvalidDocumentException e) {
                return false;
            }
            catch (PDFIOException e) {
                return false;
            }
        }
        return false;
    }

    static <T extends PDFA2AbstractErrorCode> boolean processIccProfile(PDFICCProfile pdfProfile, T newerVersionError, T olderVersionError, T version3Error, PDFA2ErrorSet<T> errorCodes, DocumentProcessor docProcessor, TrackingValidationHandler validationHandler, PDFA2ValidationOptions validationOptions, boolean checkICCVersion) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFMetadata metadata;
        if (checkICCVersion) {
            ICC_ColorSpace iccCS = (ICC_ColorSpace)pdfProfile.getColorSpace();
            ICC_Profile iccProfile = iccCS.getProfile();
            Object versionErrorCode = null;
            T t = ColorSpaceProcessor.isICCProfileVersionAllowed(iccProfile, newerVersionError, olderVersionError, version3Error);
            versionErrorCode = t;
            if (t != null) {
                errorCodes.addErrorCode(versionErrorCode);
            }
        }
        if ((metadata = pdfProfile.getMetadata()) != null && metadata.getType() == ASName.k_Metadata && metadata.getSubtype() == ASName.k_XML) {
            PDFA2XMPErrorCollector errorCodesXMP = new PDFA2XMPErrorCollector();
            if (!MetadataProcessor.processXMP(docProcessor, pdfProfile.getPDFDocument(), pdfProfile, null, null, null, validationHandler, validationOptions, errorCodesXMP)) {
                return false;
            }
            if (errorCodesXMP.hasErrors() && !validationHandler.iccProfileXMPError(errorCodesXMP)) {
                return false;
            }
        }
        return true;
    }

    static <T extends PDFA2AbstractErrorCode> T isICCProfileVersionAllowed(ICC_Profile iccProfile, T newerVersionError, T olderVersionError, T version3Error) {
        int majorVersion = iccProfile.getMajorVersion();
        if (majorVersion > 4) {
            return newerVersionError;
        }
        if (majorVersion < 2) {
            return olderVersionError;
        }
        if (majorVersion == 3) {
            return version3Error;
        }
        return null;
    }

    static boolean validateCurrentCSWithCurrentOPM(boolean overprintStrokeOrFillSet, int currentOPMValue, PDFColorSpace cs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFICCProfile profile;
        ICC_ColorSpace iccCS;
        if (currentOPMValue != 1) {
            return true;
        }
        return !((cs = ColorSpaceProcessor.getUnderLyingColorSpaceToValidate(cs)) instanceof PDFColorSpaceICCBased) || (iccCS = (ICC_ColorSpace)(profile = ((PDFColorSpaceICCBased)cs).getPDFICCProfile()).getColorSpace()).getType() != 9 || currentOPMValue != 1 || !overprintStrokeOrFillSet;
    }

    static PDFColorSpace getUnderLyingColorSpaceToValidate(PDFColorSpace colorSpace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (colorSpace instanceof PDFColorSpacePattern) {
            PDFColorSpacePattern patternCS = (PDFColorSpacePattern)colorSpace;
            return ColorSpaceProcessor.getUnderLyingColorSpaceToValidate(patternCS.getPatternColorSpace());
        }
        if (colorSpace instanceof PDFColorSpaceIndexed) {
            PDFColorSpaceIndexed indCS = (PDFColorSpaceIndexed)colorSpace;
            return ColorSpaceProcessor.getUnderLyingColorSpaceToValidate(indCS.getBaseColorSpace());
        }
        if (colorSpace instanceof PDFColorSpaceSeparation) {
            return ((PDFColorSpaceSeparation)colorSpace).getAlternateColorSpace();
        }
        if (colorSpace instanceof PDFColorSpaceDeviceN) {
            return ((PDFColorSpaceDeviceN)colorSpace).getAlternateColorSpace();
        }
        return colorSpace;
    }

    static <T extends PDFA2AbstractErrorCode> boolean processDeviceColorSpace(DocumentProcessor docProcessor, PDFResources resources, PDFA2ConformanceLevel conformance, TrackingValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFA2ErrorSet<T> errorCodes, T deviceDependentErrorCode, boolean updateCurrentCS, ASName defaultDeviceColorSpaceName, GState gState, GStateRegionInfo gStateInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<GState> gStates = new ArrayList<GState>(1);
        gStates.add(gState);
        if (!ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, deviceDependentErrorCode, defaultDeviceColorSpaceName, gStates, gStateInfo)) {
            return false;
        }
        if (updateCurrentCS) {
            gState.setCurrentCSName(defaultDeviceColorSpaceName);
        }
        return true;
    }

    static <T extends PDFA2AbstractErrorCode> boolean processDeviceColorSpace(DocumentProcessor docProcessor, PDFResources resources, TrackingValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFA2ErrorSet<T> errorCodes, T deviceDependentErrorCode, ASName defaultDeviceColorSpaceName, ArrayList<GState> gStates) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ColorSpaceProcessor.processDeviceColorSpace(docProcessor, resources, validationHandler, conversionHandler, conversionOptions, errorCodes, deviceDependentErrorCode, defaultDeviceColorSpaceName, gStates, null);
    }

    static <T extends PDFA2AbstractErrorCode> boolean processDeviceColorSpace(DocumentProcessor docProcessor, PDFResources resources, TrackingValidationHandler validationHandler, PDFA2ConversionHandler conversionHandler, PDFA2ConversionOptions conversionOptions, PDFA2ErrorSet<T> errorCodes, T deviceDependentErrorCode, ASName defaultDeviceColorSpaceName, ArrayList<GState> gStates, GStateRegionInfo gStateInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFColorSpaceMap colorSpaceMap = resources.getColorSpaceMap();
        boolean defaultDeviceColorSpaceSet = colorSpaceMap != null ? colorSpaceMap.get(defaultDeviceColorSpaceName) != null : false;
        PDFColorSpace defaultColorSpace = null;
        if (!docProcessor.isValidOutputIntentPresent(defaultDeviceColorSpaceName) && !defaultDeviceColorSpaceSet) {
            if (conversionHandler != null && (defaultColorSpace = conversionOptions.getDefaultDeviceColorSpace(defaultDeviceColorSpaceName)) != null) {
                if (colorSpaceMap == null) {
                    colorSpaceMap = PDFColorSpaceMap.newInstance(docProcessor.document);
                    resources.setColorSpaceMap(colorSpaceMap);
                }
                colorSpaceMap.set(defaultDeviceColorSpaceName, defaultColorSpace);
                if (!conversionHandler.defaultColorSpaceSet(defaultDeviceColorSpaceName, defaultColorSpace)) {
                    return false;
                }
            } else if (gStateInfo == null) {
                errorCodes.addErrorCode(deviceDependentErrorCode);
            } else if (defaultDeviceColorSpaceName == ASName.k_DefaultRGB) {
                gStateInfo.getGStateflags().setFlagSetRGBColor(true);
            } else if (defaultDeviceColorSpaceName == ASName.k_DefaultCMYK) {
                gStateInfo.getGStateflags().setFlagSetCMYKColor(true);
            } else if (defaultDeviceColorSpaceName == ASName.k_DefaultGray) {
                gStateInfo.getGStateflags().setFlagSetGrayColor(true);
            }
        }
        return ColorSpaceProcessor.process(null, defaultDeviceColorSpaceName, colorSpaceMap != null ? colorSpaceMap.get(defaultDeviceColorSpaceName) : null, docProcessor, validationHandler, resources, conversionOptions, conversionHandler, gStates);
    }
}

