/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetMetadata;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAXMPSchema;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAMetadataErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPBasicTypeValidator;
import com.adobe.internal.pdftoolkit.services.pdfa.xmp.XMPSchemaUsageValidator;
import com.adobe.internal.pdftoolkit.services.xmp.XMPMetaFactoryMonitor;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.internal.pdftoolkit.xml.XMLElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class XMPTypeValidator {
    private HashMap<XMLElement, PropertyOptions> invalidUsage = new HashMap();
    private Map<String, PDFAXMPSchema> referenceSchemas;
    private Map<String, PDFAXMPSchema> embeddedSchemas;
    private boolean schemaUsageIssueFixable;

    XMPTypeValidator(Map<String, PDFAXMPSchema> referenceSchemas, Map<String, PDFAXMPSchema> embeddedSchemas) {
        this.referenceSchemas = referenceSchemas;
        this.embeddedSchemas = embeddedSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PDFAErrorSet parse(PDFDocument document, InputStream in, ParseOptions options) throws XMPException {
        PDFAErrorSet errorFlags = this.getErrorSet();
        if (options == null) {
            options = XMPService.XMPCORE_PARSE_OPTIONS;
        }
        InputByteStream inputByteStreamXMP = null;
        InputByteStream inputByteStreamExt = null;
        try {
            InputStreamByteReader byteReader = new InputStreamByteReader(in);
            inputByteStreamXMP = document.getStreamManager().getInputByteStream(byteReader);
            inputByteStreamExt = inputByteStreamXMP.slice();
            XMPMeta xmp = XMPMetaFactoryMonitor.parse(inputByteStreamXMP.toInputStream(), options, document);
            errorFlags.mergeErrorSet(this.validate(xmp, inputByteStreamExt.toInputStream(), document));
            xmp.normalize(options);
        }
        catch (IOException e) {
            errorFlags.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
        }
        finally {
            try {
                if (inputByteStreamExt != null) {
                    inputByteStreamExt.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputByteStreamXMP != null) {
                    inputByteStreamXMP.close();
                }
            }
            catch (IOException iOException) {}
        }
        return errorFlags;
    }

    private PDFAErrorSet validate(XMPMeta xmp, InputStream in, PDFDocument document) throws XMPException {
        PDFAErrorSet errorFlags = this.getErrorSet();
        errorFlags.mergeErrorSet(this.validateExplicitSchemas(xmp, in, document));
        return errorFlags;
    }

    private PDFAErrorSet validateExplicitSchemas(XMPMeta xmp, InputStream in, PDFDocument document) {
        PDFAErrorSet errorCodes = this.getErrorSet();
        Set<String> schemaNSSet = this.referenceSchemas.keySet();
        Iterator<String> iter = schemaNSSet.iterator();
        PDFAErrorSet schemaError = this.getErrorSet();
        while (iter.hasNext()) {
            String ns = iter.next();
            if (!this.embeddedSchemas.containsKey(ns)) continue;
            PDFAXMPSchema schema = this.referenceSchemas.get(ns);
            schemaError = this.validateSchema(schema);
            errorCodes.mergeErrorSet(schemaError);
            if (!schemaError.hasErrors()) continue;
            break;
        }
        if (!schemaError.hasErrors()) {
            errorCodes.mergeErrorSet(this.validateSchemaUsage(in, xmp, document));
        }
        return errorCodes;
    }

    private PDFAErrorSet validateSchema(PDFAXMPSchema xmpSchema) {
        PDFAErrorSet errorCodes = this.getErrorSet();
        Map<String, PDFAXMPSchema.PDFAXMPProperty> propertyMap = xmpSchema.getProperties();
        Set<Map.Entry<String, PDFAXMPSchema.PDFAXMPProperty>> entrySet = propertyMap.entrySet();
        for (Map.Entry<String, PDFAXMPSchema.PDFAXMPProperty> entry : entrySet) {
            PDFAXMPSchema.PDFAXMPProperty propValue = entry.getValue();
            String base = XMPBasicTypeValidator.getBaseValueType(propValue.getType());
            PDFAXMPSchema.PDFAXMPType type = xmpSchema.getType(base);
            if (type == null) {
                if (XMPBasicTypeValidator.isValueTypeBasicXMPProperty(base)) continue;
                errorCodes.addErrorCode(PDFAMetadataErrorCode.elementUsedNotDefined);
                return errorCodes;
            }
            Map<String, PDFAXMPSchema.PDFAXMPField> fieldsMap = type.getFields();
            for (Map.Entry<String, PDFAXMPSchema.PDFAXMPField> fieldEntry : fieldsMap.entrySet()) {
                PDFAXMPSchema.PDFAXMPField field = fieldEntry.getValue();
                String baseFieldValueType = XMPBasicTypeValidator.getBaseValueType(field.getvalueType());
                Map<String, PDFAXMPSchema.PDFAXMPType> typesMap = xmpSchema.getTypes();
                if (typesMap.containsKey(baseFieldValueType) || XMPBasicTypeValidator.isValueTypeBasicXMPProperty(baseFieldValueType)) continue;
                errorCodes.addErrorCode(PDFAMetadataErrorCode.elementUsedNotDefined);
                return errorCodes;
            }
        }
        return errorCodes;
    }

    private PDFAErrorSet validateSchemaUsage(InputStream in, XMPMeta xmp, PDFDocument document) {
        PDFAErrorSet errorCodes = this.getErrorSet();
        try {
            XMLReader reader = XMLUtils.getXMLReader();
            XMPSchemaUsageValidator validator = new XMPSchemaUsageValidator(this.referenceSchemas, xmp, this.invalidUsage, document);
            validator.setParent(reader);
            validator.parse(new InputSource(in));
            this.schemaUsageIssueFixable = validator.isOnlyFixableIssuesFound();
            errorCodes.mergeErrorSet(validator.getErrorCodes());
        }
        catch (SAXException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
        }
        catch (IOException e) {
            errorCodes.addErrorCode(PDFAMetadataErrorCode.malformedMetadataXML);
        }
        return errorCodes;
    }

    private PDFAErrorSet getErrorSet() {
        return new PDFAErrorSetMetadata();
    }

    public boolean isValid() {
        return this.invalidUsage.isEmpty();
    }

    public boolean isSchemaUsageIssueFixable() {
        return this.schemaUsageIssueFixable;
    }

    public Map<XMLElement, PropertyOptions> getInvalidUsage() {
        return Collections.unmodifiableMap(this.invalidUsage);
    }
}

