/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import java.util.HashSet;

class PDFObjectCache {
    HashSet extGStates;
    HashSet fonts;
    HashSet xObjects;

    PDFObjectCache() {
    }

    private void lazyInitExtGStates() {
        if (this.extGStates == null) {
            this.extGStates = new HashSet();
        }
    }

    void add(PDFExtGState extGState) {
        this.lazyInitExtGStates();
        this.fonts.add(extGState);
    }

    boolean contains(PDFExtGState extGState) {
        return this.extGStates != null && this.extGStates.contains(extGState);
    }

    boolean remove(PDFExtGState extGState) {
        if (this.extGStates != null) {
            return this.extGStates.remove(extGState);
        }
        return false;
    }

    private void lazyInitFonts() {
        if (this.fonts == null) {
            this.fonts = new HashSet();
        }
    }

    void add(PDFFont font) {
        this.lazyInitFonts();
        this.fonts.add(font);
    }

    boolean contains(PDFFont font) {
        return this.fonts != null && this.fonts.contains(font);
    }

    boolean remove(PDFFont font) {
        if (this.fonts != null) {
            return this.fonts.remove(font);
        }
        return false;
    }

    private void lazyInitXObjects() {
        if (this.xObjects == null) {
            this.xObjects = new HashSet();
        }
    }

    void add(PDFXObject xObject) {
        this.lazyInitXObjects();
        this.fonts.add(xObject);
    }

    boolean contains(PDFXObject xObject) {
        return this.xObjects != null && this.xObjects.contains(xObject);
    }

    boolean remove(PDFXObject xObject) {
        if (this.xObjects != null) {
            return this.xObjects.remove(xObject);
        }
        return false;
    }
}

