/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DroppedInstructionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.InstructionReplacer;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.PathPaintingInstructionHandler;
import java.util.HashMap;

public class OptionalContentInstructionReplacer {
    private static final boolean DEBUG_INSTRUCTIONS = false;
    private static HashMap<ASName, InstructionReplacer> operatorsHandlers = new HashMap();

    static Instruction getReplacement(Instruction origInstruction) {
        InstructionReplacer replacer = operatorsHandlers.get(origInstruction.getOperator());
        if (replacer != null) {
            Instruction finalI = replacer.getSubstitute(origInstruction);
            return finalI;
        }
        return origInstruction;
    }

    static {
        operatorsHandlers.put(ASName.k_S, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_s, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_f, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_F, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_fStar, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_B, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_BStar, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_b, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_bStar, PathPaintingInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_TJ, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_Tj, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_SingleQuote, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_DoubleQuote, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_sh, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_BI, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_ID, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_EI, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_Do, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_BDC, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_BMC, DroppedInstructionHandler.getInstance());
        operatorsHandlers.put(ASName.k_EMC, DroppedInstructionHandler.getInstance());
    }
}

