/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.StatefulContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.FontDetailsCollectionOperatorHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmbeddedFontDetailsCollector {
    private PDFDocument pdfDocument;
    private Map<PDFFont, EmbeddedFontDetails> fontDetailsMap;

    public EmbeddedFontDetailsCollector(PDFDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.fontDetailsMap = new HashMap<PDFFont, EmbeddedFontDetails>();
    }

    public Collection<EmbeddedFontDetails> getEmbeddedFontDetails() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<PDFPage> iter = this.pdfDocument.requirePages().iterator();
        while (iter.hasNext()) {
            PDFPage page = iter.next();
            this.populateEmbeddedFontDetails(page);
        }
        return this.fontDetailsMap.values();
    }

    private void populateEmbeddedFontDetails(PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FontDetailsCollectionOperatorHandler handler = new FontDetailsCollectionOperatorHandler(pdfPage, this.fontDetailsMap);
        StatefulContentStreamProcessor streamProcessor = new StatefulContentStreamProcessor(handler);
        streamProcessor.process(pdfPage);
    }
}

