/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class EmbeddedFontDetails {
    private PDFFont pdfFont;
    private Font afeFont;
    private HashSet<int[]> unicodeValues;
    private HashMap<Integer, Integer> charCodeToGlyphIdMap;
    private HashMap<Integer, int[]> charCodeToUnicodeMap;

    public EmbeddedFontDetails(PDFFont pdfFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfFont = pdfFont;
        try {
            this.afeFont = pdfFont.getAFEFont(false);
        }
        catch (FontLoadingException e) {
            throw new PDFInvalidDocumentException("Exception occuring while getting AFEFont for " + pdfFont, e);
        }
        this.unicodeValues = new HashSet();
        this.charCodeToGlyphIdMap = new HashMap();
        this.charCodeToUnicodeMap = new HashMap();
    }

    public PDFFont getPdfFont() {
        return this.pdfFont;
    }

    public Font getAfeFont() {
        return this.afeFont;
    }

    public void addGlyphIdentifiers(byte[] charcode, int[] unicode, Integer glyphId) {
        this.unicodeValues.add(unicode);
        Integer charCodeInt = (int)PDFCMapUtils.getCharCode(charcode);
        this.charCodeToGlyphIdMap.put(charCodeInt, glyphId);
        this.charCodeToUnicodeMap.put(charCodeInt, unicode);
    }

    public Collection<Integer> getGlyphIds() {
        return this.charCodeToGlyphIdMap.values();
    }

    public HashSet<int[]> getUnicodeValues() {
        return this.unicodeValues;
    }

    public HashMap<Integer, Integer> getCharCodeToGlyphIdMap() {
        return this.charCodeToGlyphIdMap;
    }

    public HashMap<Integer, int[]> getCharCodeToUnicodeMap() {
        return this.charCodeToUnicodeMap;
    }
}

