/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFEncodingDifferences;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.SubsetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class TrueTypeFontSubsetter
extends FontSubsetter {
    protected Map<PDFEncodingDifferences, List<PDFFont>> fontEncodingToFontInfoMap = new HashMap<PDFEncodingDifferences, List<PDFFont>>();

    public TrueTypeFontSubsetter(PDFDocument pdfDoc, Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap) {
        super(pdfDoc, fontToCharCodesMap);
    }

    @Override
    protected void populateFontInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        for (Map.Entry fontToCharCodesEntry : this.fontToCharCodesMap.entrySet()) {
            PDFFontSimple pdfFont = (PDFFontSimple)fontToCharCodesEntry.getKey();
            PDFFontDescriptor fontDescriptor = pdfFont.getFontDescriptor();
            PDFFontFile fontFile = PDFFontUtils.getFontFileFromFontDescriptor(fontDescriptor);
            TrueTypeFontInfo fontInfo = null;
            fontInfo = this.fontFileToFontInfoMap.containsKey(fontFile) ? (TrueTypeFontInfo)this.fontFileToFontInfoMap.get(fontFile) : new TrueTypeFontInfo();
            try {
                if (fontInfo.getFont() == null) {
                    fontInfo.setFont(pdfFont.getAFEFont());
                }
                if (fontInfo.openTypeCmapSubtable == null) {
                    fontInfo.openTypeCmapSubtable = PDFFontUtils.getOpenTypeCmapSubTableType(pdfFont);
                }
                fontInfo.getPDFFontDescSet().add(fontDescriptor);
                for (Integer charCode : ((TreeMap)fontToCharCodesEntry.getValue()).keySet()) {
                    int codePoint = pdfFont.charCode2CodePoint(charCode);
                    fontInfo.getCodePointsSet().add(codePoint);
                }
            }
            catch (FontLoadingException e) {
                throw new PDFFontException(e);
            }
            catch (InvalidFontException e) {
                throw new PDFFontException(e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFFontException(e);
            }
            this.fontFileToFontInfoMap.put(fontFile, fontInfo);
            PDFSimpleFontEncoding fontEncoding = pdfFont.getEncoding();
            if (fontEncoding == null || fontEncoding.getDifferences() == null) continue;
            List<PDFFont> fontInfoList = this.fontEncodingToFontInfoMap.get(fontEncoding.getDifferences());
            if (fontInfoList == null) {
                fontInfoList = new ArrayList<PDFFont>();
            }
            fontInfoList.add(pdfFont);
            this.fontEncodingToFontInfoMap.put(fontEncoding.getDifferences(), fontInfoList);
        }
    }

    @Override
    protected void doSubsetting() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        for (Map.Entry fontFileToFontInfoEntry : this.fontFileToFontInfoMap.entrySet()) {
            PDFFontFile fontFile = (PDFFontFile)fontFileToFontInfoEntry.getKey();
            TrueTypeFontInfo fontInfo = (TrueTypeFontInfo)fontFileToFontInfoEntry.getValue();
            Set<Integer> codePointsSet = fontInfo.getCodePointsSet();
            int[] codePoints = new int[codePointsSet.size()];
            Iterator<Integer> codePointsIterator = codePointsSet.iterator();
            int count = 0;
            while (codePointsIterator.hasNext()) {
                codePoints[count++] = codePointsIterator.next();
            }
            Font afeFont = fontInfo.getFont();
            this.subsetTrueTypeFontStream(fontFile.getPDFDocument(), codePoints, afeFont, fontInfo.getPDFFontDescSet(), fontInfo.openTypeCmapSubtable);
        }
        for (Map.Entry fontToCharCodeEntry : this.fontToCharCodesMap.entrySet()) {
            SubsetUtils.cleanUpSimpleFontDict((PDFFont)fontToCharCodeEntry.getKey(), (TreeMap)fontToCharCodeEntry.getValue(), this.fontEncodingToFontInfoMap);
        }
    }

    private void subsetTrueTypeFontStream(PDFDocument pdfDoc, int[] charCodes, Font afeFont, Set<PDFFontDescriptor> fontDescriptorSet, PDFFontUtils.OpenTypeCmapSubTableType openTypeCmapSubTableType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        try {
            OutputByteStream subsetStream = pdfDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
            FontResources.getSubsettedFontTrueTypeStream(charCodes, afeFont, subsetStream.toOutputStream(), openTypeCmapSubTableType);
            InputByteStream subsetInputStream = subsetStream.closeAndConvert();
            PDFFontFile fontFile = PDFFontFile.newInstance(pdfDoc);
            fontFile.getCosStream().newDataDecoded(subsetInputStream);
            fontFile.setFilter(PDFFilterFlate.newInstance(pdfDoc, null));
            fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.OpenType);
            for (PDFFontDescriptor pdfFontDescriptor : fontDescriptorSet) {
                pdfFontDescriptor.setFontFile(null);
                pdfFontDescriptor.setFontFile2(null);
                pdfFontDescriptor.setFontFile3(fontFile);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private static class TrueTypeFontInfo
    extends FontSubsetter.FontInfo {
        Set<Integer> codePointsSet = new LinkedHashSet<Integer>();
        Set<PDFFontDescriptor> pdfFontDescriptorSet = new LinkedHashSet<PDFFontDescriptor>();
        PDFFontUtils.OpenTypeCmapSubTableType openTypeCmapSubtable;

        private TrueTypeFontInfo() {
        }

        Set<Integer> getCodePointsSet() {
            return this.codePointsSet;
        }

        Set<PDFFontDescriptor> getPDFFontDescSet() {
            return this.pdfFontDescriptorSet;
        }
    }
}

