/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import java.util.Iterator;
import java.util.Set;

public final class SignatureFlags {
    private SignatureFlags() {
    }

    public static void signatureFieldAdded(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFlags.setSignatureFlags(pdfDoc, 1);
    }

    public static void byteRangeSignatureAdded(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFlags.setSignatureFlags(pdfDoc, 2);
    }

    private static void setSignatureFlags(PDFDocument pdfDoc, int bitPosition) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDoc.requireCatalog().procureInteractiveForm();
        int prevSigFlags = iform.getSigFlags();
        int newSigFlags = prevSigFlags | bitPosition;
        if (newSigFlags != prevSigFlags) {
            iform.setSigFlags(newSigFlags);
        }
    }

    public static void signatureFieldUnsignedOrSignatureRemoved(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFlags.signatureFieldUnsignedOrSignatureRemovedList(pdfDoc, null);
    }

    public static void signatureFieldUnsignedOrSignatureRemovedList(PDFDocument pdfDoc, Set<String> removedField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPermissions perms;
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        if (iform == null) {
            return;
        }
        int prevSigFlags = iform.getSigFlags();
        int sigFlags = prevSigFlags & 0xFFFFFFFC;
        SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
        boolean sigFieldFound = false;
        boolean signedSigFieldFound = false;
        Iterator<SignatureFieldInterface> iter = sigMgr.getPDFSignatureFieldIterator();
        while (iter.hasNext()) {
            sigFieldFound = true;
            SignatureFieldInterface sigField = iter.next();
            if (sigField.isSigned()) {
                signedSigFieldFound = true;
            }
            if (!sigFieldFound || !signedSigFieldFound) continue;
            break;
        }
        if (sigFieldFound) {
            sigFlags |= 1;
        }
        if (signedSigFieldFound) {
            sigFlags |= 2;
        } else if (sigMgr.hasPermissionsSignature() && (perms = pdfDoc.requireCatalog().getPermissions()).getUR3() != null) {
            sigFlags |= 2;
        }
        if (prevSigFlags != sigFlags) {
            iform.setSigFlags(sigFlags);
        }
        if (iform.getSigFlags() == 0) {
            iform.removeSigFlags();
        }
    }
}

