/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public final class RSATimeStampingUtil {
    public static X501Attributes createTSAttribute(SignedData signedData, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        byte[] encryptedDigest = RSATimeStampingUtil.getEncryptedDigest(signedData);
        return RSATimeStampingUtil.createTSAttribute(encryptedDigest, tsProvider, isDummyToken);
    }

    public static X501Attributes createTSAttribute(byte[] encryptedDigest, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        X501Attributes attributeList = new X501Attributes();
        tsProvider.setDataToTimestamp(encryptedDigest);
        byte[] tstokenbytes = isDummyToken ? RSATimeStampingUtil.createDummyTimestampToken(tsProvider) : tsProvider.getTimestampToken();
        if (tstokenbytes == null || tstokenbytes.length == 0) {
            return null;
        }
        NonStandardAttribute tsAttrib = new NonStandardAttribute();
        byte[] oid = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 2, 14};
        tsAttrib.setOID(oid, 0, oid.length);
        tsAttrib.setValue(tstokenbytes, 0, tstokenbytes.length);
        attributeList.addAttribute((X501Attribute)tsAttrib);
        return attributeList;
    }

    private static byte[] createDummyTimestampToken(TimeStampProvider tsProvider) throws PDFSignatureException {
        int timestampTokenSize = tsProvider.getTimestampTokenSize();
        if (timestampTokenSize == 0) {
            throw new PDFSignatureException("The timestamp token size is zero, The dummy pkcs#7 digest cannot be built");
        }
        return new byte[timestampTokenSize];
    }

    public static int addTSAttributeToSignerInfo(SignedData signedData, TimeStampProvider tsProvider, boolean isDummyToken) throws PDFSignatureException {
        if (tsProvider == null) {
            throw new PDFSignatureException("No timestamp provider has been registered with the SignatureManager");
        }
        Vector listOfSigners = signedData.getSignerInfos();
        Enumeration e = listOfSigners.elements();
        while (e.hasMoreElements()) {
            SignerInfo retrievedSigner = (SignerInfo)e.nextElement();
            try {
                X501Attributes attributes = RSATimeStampingUtil.createTSAttribute(signedData, tsProvider, isDummyToken);
                if (attributes == null) {
                    return 0;
                }
                retrievedSigner.setUnauthenticatedAttrs(attributes);
            }
            catch (PKCS7Exception e1) {
                throw new PDFSignatureException("Could not set the timestamp as an unauthenticated attribute of SignerInfo", e1);
            }
        }
        return 1;
    }

    private static byte[] getEncryptedDigest(SignedData signedData) {
        byte[] encryptedDigest = null;
        Vector signerInfoList = signedData.getSignerInfos();
        ArrayList list = new ArrayList(signerInfoList);
        Iterator iter = list.iterator();
        if (iter.hasNext()) {
            SignerInfo signerInfo = (SignerInfo)iter.next();
            encryptedDigest = signerInfo.getEncryptedDigest();
        }
        return encryptedDigest;
    }
}

