/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAVerifyUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RSAPKCS7SHA1Verifier
extends Verifier {
    private final AbstractDigester digester;

    public RSAPKCS7SHA1Verifier(AbstractDigester digester) throws PDFSignatureException {
        this.digester = digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(InputStream inputStream, byte[] signaturePacketData) throws PDFSignatureException {
        try {
            this.digester.feedDataToDigester(inputStream);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("Could not close the underlying IBS in ByteRangeInputStream", e);
        }
        try {
            byte[] digest = this.digester.calculateDigest();
            inputStream = new ByteArrayInputStream(digest);
            boolean bl = RSAVerifyUtils.verify(signaturePacketData, inputStream);
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

