/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionException;
import com.adobe.internal.pdftoolkit.services.ap.extension.ButtonApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.RadioCheckButtonAppearanceGenerator;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;

public class RadioButtonApProviderImpl
extends RadioCheckButtonAppearanceGenerator
implements ButtonApProvider {
    private RadioButtonApProviderImpl(APResources apResources, PDFDocument pdfDoc, PDFResources defResources) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        super(apResources, pdfDoc, defResources);
        this.buttonDefaultStyle = "l";
        this.circularBorderForCircleStyle = true;
    }

    public static RadioButtonApProviderImpl getInstance(APResources apResources, PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDFDocument cant be passed as null");
        }
        PDFInteractiveForm form = pdfDoc.getInteractiveForm();
        if (form == null) {
            return null;
        }
        return new RadioButtonApProviderImpl(apResources, pdfDoc, form.getResources());
    }

    @Override
    public void generateAppearance(PDFFieldButton buttonField) throws APExtensionException {
        try {
            if (buttonField == null || !buttonField.isRadioButton()) {
                return;
            }
            super.generateFieldAppearance(buttonField);
        }
        catch (Exception e) {
            throw new APExtensionException("Error generating appearance for button field (Object number: " + buttonField.getCosObject().getObjNum(), e);
        }
    }
}

