/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class OpacityBox
extends Jpeg2000Box {
    private int opacityType;
    private int numberOfChannels;
    private InputByteStream chromaKeyValues;

    OpacityBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getOpacityType() throws IOException {
        this.lazilyPopulateFields();
        return this.opacityType;
    }

    public int getNumberOfChannels() throws IOException {
        this.lazilyPopulateFields();
        return this.numberOfChannels;
    }

    public InputByteStream getChromaKeyValues() throws IOException {
        this.lazilyPopulateFields();
        return this.chromaKeyValues != null ? this.chromaKeyValues.slice() : null;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.opacityType = Jpeg2000Utils.bytesToInteger(boxContents, 1);
            if (this.opacityType != 2) {
                this.numberOfChannels = Jpeg2000Utils.bytesToInteger(boxContents, 1);
                this.chromaKeyValues = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.chromaKeyValues != null) {
                this.chromaKeyValues.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

