/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.BitsPerComponentBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ChannelDefinitionBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ColourSpecificationBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ComponentMappingBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ImageHeaderBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.LabelBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.PaletteBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.ResolutionBox;
import java.io.IOException;

public class JP2HeaderBox
extends Jpeg2000Box {
    private LabelBox labelBox;
    private ImageHeaderBox imageHeaderBox;
    private BitsPerComponentBox bitsPerComponentBox;
    private Jpeg2000BoxesList<ColourSpecificationBox> colourSpecificationBoxesList;
    private PaletteBox paletteBox;
    private ComponentMappingBox componentMappingBox;
    private ChannelDefinitionBox channelDefinitionBox;
    private ResolutionBox resolutionBox;

    JP2HeaderBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public LabelBox getLabelBox() throws IOException {
        this.lazilyPopulateFields();
        return this.labelBox;
    }

    public ImageHeaderBox getImageHeaderBox() throws IOException {
        this.lazilyPopulateFields();
        return this.imageHeaderBox;
    }

    public BitsPerComponentBox getBitsPerComponentBox() throws IOException {
        this.lazilyPopulateFields();
        return this.bitsPerComponentBox;
    }

    public Jpeg2000BoxesList<ColourSpecificationBox> getColourSpecificationBoxesList() throws IOException {
        this.lazilyPopulateFields();
        return this.colourSpecificationBoxesList;
    }

    public PaletteBox getPaletteBox() throws IOException {
        this.lazilyPopulateFields();
        return this.paletteBox;
    }

    public ComponentMappingBox getComponentMappingBox() throws IOException {
        this.lazilyPopulateFields();
        return this.componentMappingBox;
    }

    public ChannelDefinitionBox getChannelDefinitionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.channelDefinitionBox;
    }

    public ResolutionBox getResolutionBox() throws IOException {
        this.lazilyPopulateFields();
        return this.resolutionBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) continue;
                switch (innerBoxType) {
                    case labelBox: {
                        this.labelBox = new LabelBox(innerBoxInfo);
                        break;
                    }
                    case imageHeaderBox: {
                        this.imageHeaderBox = new ImageHeaderBox(innerBoxInfo);
                        break;
                    }
                    case bitsPerComponentBox: {
                        this.bitsPerComponentBox = new BitsPerComponentBox(innerBoxInfo);
                        break;
                    }
                    case colourSpecificationBox: {
                        if (this.colourSpecificationBoxesList == null) {
                            this.colourSpecificationBoxesList = new Jpeg2000BoxesList();
                        }
                        this.colourSpecificationBoxesList.add(new ColourSpecificationBox(innerBoxInfo));
                        break;
                    }
                    case paletteBox: {
                        this.paletteBox = new PaletteBox(innerBoxInfo);
                        break;
                    }
                    case componentMappingBox: {
                        this.componentMappingBox = new ComponentMappingBox(innerBoxInfo);
                        break;
                    }
                    case channelDefinitionBox: {
                        this.channelDefinitionBox = new ChannelDefinitionBox(innerBoxInfo);
                        break;
                    }
                    case resolutionBox: {
                        this.resolutionBox = new ResolutionBox(innerBoxInfo);
                        break;
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.labelBox != null) {
                this.labelBox.close();
            }
        }
        finally {
            try {
                if (this.imageHeaderBox != null) {
                    this.imageHeaderBox.close();
                }
            }
            finally {
                try {
                    if (this.bitsPerComponentBox != null) {
                        this.bitsPerComponentBox.close();
                    }
                }
                finally {
                    try {
                        if (this.colourSpecificationBoxesList != null) {
                            this.colourSpecificationBoxesList.close();
                        }
                    }
                    finally {
                        try {
                            if (this.paletteBox != null) {
                                this.paletteBox.close();
                            }
                        }
                        finally {
                            try {
                                if (this.componentMappingBox != null) {
                                    this.componentMappingBox.close();
                                }
                            }
                            finally {
                                try {
                                    if (this.channelDefinitionBox != null) {
                                        this.channelDefinitionBox.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (this.resolutionBox != null) {
                                            this.resolutionBox.close();
                                        }
                                    }
                                    finally {
                                        this.boxInfo.clearContents();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

