/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Utils;
import java.io.IOException;

public class InstructionSetBox
extends Jpeg2000Box {
    private int instructionType;
    private int repetition;
    private long tick;
    private InputByteStream instructionSeries;

    InstructionSetBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public int getInstructionType() throws IOException {
        this.lazilyPopulateFields();
        return this.instructionType;
    }

    public int getRepetition() throws IOException {
        this.lazilyPopulateFields();
        return this.repetition;
    }

    public long getTick() throws IOException {
        this.lazilyPopulateFields();
        return this.tick;
    }

    public InputByteStream getInstructionSeries() throws IOException {
        this.lazilyPopulateFields();
        return this.instructionSeries != null ? this.instructionSeries.slice() : null;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            this.instructionType = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.repetition = Jpeg2000Utils.bytesToInteger(boxContents, 2);
            this.tick = Jpeg2000Utils.bytesToLong(boxContents, 4);
            this.instructionSeries = boxContents.slice(boxContents.getPosition(), boxContents.bytesAvailable());
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.instructionSeries != null) {
                this.instructionSeries.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

