/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.GraphicsTechnologyStandardOutputBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import java.io.IOException;

public class DesiredReproductionsBox
extends Jpeg2000Box {
    private GraphicsTechnologyStandardOutputBox graphicsTechnologyStandardOutputBox;

    DesiredReproductionsBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public GraphicsTechnologyStandardOutputBox getGraphicsTechnologyStandardOutputBox() throws IOException {
        this.lazilyPopulateFields();
        return this.graphicsTechnologyStandardOutputBox;
    }

    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                if (innerBoxInfo.getType() != Jpeg2000BoxType.graphicsTechStandardOutputBox) continue;
                this.graphicsTechnologyStandardOutputBox = new GraphicsTechnologyStandardOutputBox(innerBoxInfo);
                break;
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    @Override
    protected void close() throws IOException {
        try {
            if (this.graphicsTechnologyStandardOutputBox != null) {
                this.graphicsTechnologyStandardOutputBox.close();
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }
}

