/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneWithFunction;

public class PDFHalftoneType16
extends PDFHalftoneWithFunction {
    private PDFHalftoneType16(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFHalftoneType16 newInstance(PDFDocument pdfDocument, int key_Width, int key_Height) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFHalftoneType16 pdfObject = new PDFHalftoneType16(cosObject);
        pdfObject.setHalftoneType(PDFHalfToneType.HALFTONE_TYPE16);
        pdfObject.setWidth(key_Width);
        pdfObject.setHeight(key_Height);
        return pdfObject;
    }

    public static PDFHalftoneType16 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFHalftoneType16 pdfObject = (PDFHalftoneType16)PDFCosObject.getCachedInstance(cosObject, PDFHalftoneType16.class);
        if (pdfObject == null) {
            pdfObject = new PDFHalftoneType16(cosObject);
        }
        return pdfObject;
    }

    public int getWidth2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasWidth2()) {
            return -1;
        }
        return this.getDictionaryIntValue(ASName.k_Width2);
    }

    public void setWidth2(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width2, value);
    }

    public boolean hasWidth2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width2);
    }

    public int getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Width);
    }

    public void setWidth(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Width, value);
    }

    public int requireWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Width);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Width.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width);
    }

    public int getHeight2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasHeight2()) {
            return -1;
        }
        return this.getDictionaryIntValue(ASName.k_Height2);
    }

    public void setHeight2(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height2, value);
    }

    public boolean hasHeight2() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height2);
    }

    public int getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_Height);
    }

    public void setHeight(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Height, value);
    }

    public int requireHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_Height);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get Height.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height);
    }
}

