/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeList;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.util.ArrayListStack;
import java.util.Iterator;

public class PDFPageTree
extends PDFPageTreeNode {
    private PDFPageTree(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageTree getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageTree pdfObject = (PDFPageTree)PDFCosObject.getCachedInstance(cosObject, PDFPageTree.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageTree(cosObject);
        }
        return pdfObject;
    }

    public static PDFPageTree requireInstance(CosObject cosObject) throws PDFInvalidParameterException, PDFInvalidDocumentException {
        PDFPageTree pdfObject = PDFPageTree.getInstance(cosObject);
        if (pdfObject == null) {
            throw new PDFInvalidParameterException("Required instance unable to be constructed.");
        }
        return pdfObject;
    }

    public static PDFPageTree newInstance(PDFDocument pdfDoc, PDFPage firstPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray treeList = PDFCosObject.newCosArray(pdfDoc);
        treeList.add(firstPage.getCosObject());
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDoc);
        cosObject.put(ASName.k_Type, ASName.k_Pages);
        cosObject.put(ASName.k_Kids, treeList);
        cosObject.put(ASName.k_Count, 1);
        pdfDoc.requireCatalog().getCosDictionary().put(ASName.k_Pages, cosObject);
        PDFPageTree pageTree = new PDFPageTree(cosObject);
        firstPage.setDictionaryValue(ASName.k_Parent, pageTree);
        return pageTree;
    }

    private PDFPage findPageInNode(PDFPageTreeNode node, int index, int least) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (index < least) {
            return null;
        }
        int count = node.getCount() + least;
        if (index >= count) {
            return null;
        }
        return this.findPageInList(node.getKids(), index, least);
    }

    private PDFPage findPageInList(PDFPageTreeList list, int index, int least) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            if (obj instanceof PDFPage) {
                if (least == index) {
                    return (PDFPage)obj;
                }
                ++least;
                continue;
            }
            PDFPage page = this.findPageInNode((PDFPageTreeNode)obj, index, least);
            if (page != null) {
                return page;
            }
            least += ((PDFPageTreeNode)obj).getCount();
        }
        return null;
    }

    public PDFPage getLastPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayListStack<Integer> nodeIndexStack = new ArrayListStack<Integer>();
        PDFPageTreeNode right = this;
        while (!(right instanceof PDFPage)) {
            PDFPageTreeList kidList = right.getKids();
            int nodeIndex = kidList.size() - 1;
            while (nodeIndex < 0) {
                if (nodeIndexStack.isEmpty()) {
                    throw new PDFInvalidDocumentException("No pages in the document's page tree.");
                }
                right = right.getParent();
                nodeIndex = (Integer)nodeIndexStack.pop() - 1;
                kidList = right.getKids();
            }
            nodeIndexStack.push(nodeIndex);
            right = (PDFPageTreeNode)kidList.get(nodeIndex);
        }
        return (PDFPage)right;
    }

    public PDFPage getPage(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPageInNode(this.getPDFDocument().requirePages(), 0, index);
    }

    private PDFPage getPageInNode(PDFPageTreeNode node, int start, int pageNum) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int last = start + node.getCount();
        if (pageNum >= last) {
            return null;
        }
        for (PDFPageTreeNode curNode : node.getKids()) {
            if (curNode instanceof PDFPage) {
                if (start == pageNum) {
                    return (PDFPage)curNode;
                }
                ++start;
                continue;
            }
            PDFPage curPage = this.getPageInNode(curNode, start, pageNum);
            if (curPage != null) {
                return curPage;
            }
            start += curNode.getCount();
        }
        return null;
    }

    public void removePage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<PDFPage> pages = this.iterator();
        while (pages.hasNext()) {
            if (pages.next() != page) continue;
            pages.remove();
        }
    }

    public int size() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCount();
    }

    public int getNumPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCount();
    }

    @Override
    public boolean isEmpty() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCount() == 0;
    }

    public Object get(int index) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPage(index);
    }

    public Object[] toArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Object[] allPages = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            allPages[i] = this.get(i);
        }
        return allPages;
    }

    public boolean movePage(Integer nPage, Integer nAfter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage page;
        boolean prependPage = false;
        if (nAfter == null) {
            nAfter = this.getLastPage().getPageIndex() - 1;
        } else {
            if (nAfter.equals(nPage)) {
                return true;
            }
            if (nAfter == -1) {
                prependPage = true;
            } else if (nPage < nAfter) {
                Integer n = nAfter;
                Integer n2 = nAfter = Integer.valueOf(nAfter - 1);
            }
        }
        if (nPage != null && (page = this.getPage(nPage)) != null) {
            this.removePage(page);
            if (prependPage) {
                this.getPage(0).prependPage(page);
            } else {
                PDFPage appendAfterPage = this.getPage(nAfter);
                if (appendAfterPage != null) {
                    appendAfterPage.appendPage(page);
                }
            }
            return true;
        }
        return false;
    }
}

