/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNumberTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageLabel;

public class PDFPageLabels
extends PDFNumberTree<PDFPageLabel> {
    private PDFPageLabels(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPageLabels getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPageLabels pdfObject = (PDFPageLabels)PDFCosObject.getCachedInstance(cosObject, PDFPageLabels.class);
        if (pdfObject == null) {
            pdfObject = new PDFPageLabels(cosObject);
        }
        return pdfObject;
    }

    public static PDFPageLabels newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFPageLabels(cosObject);
    }

    @Override
    protected PDFPageLabel makeValueType(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        return PDFPageLabel.getInstance(cosObject);
    }

    @Override
    protected CosObject getCosObjectFromValue(PDFPageLabel value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return value.getCosObject();
    }

    public PDFPageLabel split(int pageIndex) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        Number existingKey = this.previousKey(pageIndex);
        if (existingKey == null) {
            return null;
        }
        PDFPageLabel startLabel = (PDFPageLabel)this.getEntry(existingKey.intValue());
        if (startLabel == null) {
            return null;
        }
        if (existingKey.intValue() == pageIndex) {
            return startLabel;
        }
        PDFPageLabel newLabel = startLabel;
        try {
            if (this.getEntry(pageIndex) == null) {
                newLabel = PDFPageLabel.newInstance(this.getPDFDocument(), startLabel);
                newLabel.setStartingNumber(pageIndex - existingKey.intValue() + startLabel.getStartingNumber());
                this.replaceEntry(pageIndex, newLabel);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Page label cannot be replaced", e);
        }
        return newLabel;
    }
}

