/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFSound
extends PDFCosStream {
    private PDFSound(CosObject cosStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosStream);
    }

    public static PDFSound newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosStream cosStream = PDFCosObject.newCosStream(pdfDocument);
        PDFSound pdfObject = new PDFSound(cosStream);
        pdfObject.setType();
        return pdfObject;
    }

    public static PDFSound getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSound pdfObject = (PDFSound)PDFCosObject.getCachedInstance(cosObject, PDFSound.class);
        if (pdfObject == null) {
            pdfObject = new PDFSound(cosObject);
        }
        return pdfObject;
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_Sound);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_E);
    }

    public void setEncoding(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Encoding is a required key therefore cannot be removed.");
        }
        if (!(value.equals(ASName.k_Raw) || value.equals(ASName.k_Signed) || value.equals(ASName.k_muLaw) || value.equals(ASName.k_ALaw))) {
            throw new PDFInvalidParameterException("Value " + value + " is outside of bound for Encoding.");
        }
        this.setDictionaryNameValue(ASName.k_E, value);
    }

    public boolean hasEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_E);
    }

    public CosDictionary getCompressionParamsAsDict() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_CP);
    }

    public void setCompressionParams(CosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_CP, value);
    }

    public CosStream getCompressionParamsAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(ASName.k_CP);
        if (cosObject instanceof CosStream) {
            return (CosStream)cosObject;
        }
        return null;
    }

    public void setCompressionParams(CosStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_CP, value);
    }

    public CosArray getCompressionParamsAsArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_CP);
    }

    public void setCompressionParams(CosArray value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_CP, value);
    }

    public boolean hasCompressionParams() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CP);
    }

    public int getBitsPerSample() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_B);
    }

    public void setBitsPerSample(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_B, value);
    }

    public boolean hasBitsPerSample() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_B);
    }

    public int getChannelsNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_C);
    }

    public void setChannelsNumber(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_C, value);
    }

    public boolean hasChannelsNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }

    public ASName getCompressionFormat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_CO);
    }

    public void setCompressionFormat(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryNameValue(ASName.k_CO, value);
    }

    public boolean hasCompressionFormat() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CO);
    }

    public double getSamplingRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDoubleValue(ASName.k_R);
    }

    public void setSamplingRate(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_R, value);
    }

    public boolean hasSamplingRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_R);
    }
}

