/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFAlternatePresentations;

public class PDFSlideShow
extends PDFAlternatePresentations {
    private PDFSlideShow(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSlideShow newInstance(PDFDocument pdfDocument, PDFResources key_Resources, ASString key_StartResource) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Resources == null) {
            throw new PDFInvalidParameterException("Resources is required when creating newInstance of PDFSlideShow.");
        }
        if (key_StartResource == null) {
            throw new PDFInvalidParameterException("StartResource is required when creating newInstance of PDFSlideShow.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSlideShow pdfObject = new PDFSlideShow(cosObject);
        pdfObject.setType();
        pdfObject.setSubtype();
        pdfObject.setResources(key_Resources);
        pdfObject.setStartResource(key_StartResource);
        return pdfObject;
    }

    public static PDFSlideShow getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSlideShow pdfObject = (PDFSlideShow)PDFCosObject.getCachedInstance(cosObject, PDFSlideShow.class);
        if (pdfObject == null) {
            pdfObject = new PDFSlideShow(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_SlideShow);
    }

    public ASName requireType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Type);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Type.");
        }
        return name;
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Subtype, ASName.k_Embedded);
    }

    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_Subtype);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Subtype);
    }

    public ASString getStartResource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_StartResource);
    }

    public void setStartResource(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("StartResource is a required key therefore cannot be removed.");
        }
        this.setDictionaryASStringValue(ASName.k_StartResource, value);
    }

    public void setStartResource(byte[] value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("StartResource is a required key therefore cannot be removed.");
        }
        this.setDictionaryByteArrayValue(ASName.k_StartResource, value);
    }

    public ASString requireStartResource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString name = this.getDictionaryStringValue(ASName.k_StartResource);
        if (name == null) {
            throw new PDFInvalidDocumentException("Could not get StartResource");
        }
        return name;
    }

    public boolean hasStartResource() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_StartResource);
    }

    public PDFResources getResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
    }

    public void setResources(PDFResources value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Resources is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_Resources, value);
    }

    public PDFResources requireResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources pdfObject = PDFResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_Resources));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get Resources");
        }
        return pdfObject;
    }

    public boolean hasResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Resources);
    }
}

