/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaPosition;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaWindowDefault;

public class PDFRichMediaWindow
extends PDFCosDictionary {
    PDFRichMediaWindow(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaWindow newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaWindow pdfObject = new PDFRichMediaWindow(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaWindow getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaWindow pdfObject = (PDFRichMediaWindow)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaWindow.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaWindow(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(ASName.k_RichMediaWindow)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidDocumentException("Type value is not valid. " + ASName.k_RichMediaWindow + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public PDFRichMediaWindowDefault getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaWindowDefault.getInstance(this.getDictionaryCosObjectValue(ASName.k_Width));
    }

    public void setWidth(PDFRichMediaWindowDefault value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Width, value);
    }

    public boolean hasWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Width);
    }

    public PDFRichMediaWindowDefault getHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaWindowDefault.getInstance(this.getDictionaryCosObjectValue(ASName.k_Height));
    }

    public void setHeight(PDFRichMediaWindowDefault value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Height, value);
    }

    public boolean hasHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Height);
    }

    public PDFRichMediaPosition getPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaPosition.getInstance(this.getDictionaryCosObjectValue(ASName.k_Position));
    }

    public void setPosition(PDFRichMediaPosition value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Position, value);
    }

    public boolean hasPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Position);
    }
}

