/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaInstance;

public class PDFRichMediaViewParams
extends PDFCosDictionary {
    public static final ASName k_Instance = ASName.create("Instance");
    public static final ASName k_Data = ASName.create("Data");

    private PDFRichMediaViewParams(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaViewParams newInstance(PDFDocument pdfDocument, PDFRichMediaInstance instance, PDFText data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaViewParams pdfObject = new PDFRichMediaViewParams(cosObject);
        pdfObject.setInstance(instance);
        pdfObject.setDataAsTextString(data);
        return pdfObject;
    }

    public static PDFRichMediaViewParams newInstance(PDFDocument pdfDocument, PDFRichMediaInstance instance, PDFStream data) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaViewParams pdfObject = new PDFRichMediaViewParams(cosObject);
        pdfObject.setInstance(instance);
        pdfObject.setDataAsStream(data);
        return pdfObject;
    }

    public static PDFRichMediaViewParams getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaViewParams pdfObject = (PDFRichMediaViewParams)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaViewParams.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaViewParams(cosObject);
        }
        return pdfObject;
    }

    public PDFRichMediaInstance getInstance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaInstance.getInstance(this.getDictionaryCosObjectValue(k_Instance));
    }

    public void setInstance(PDFRichMediaInstance value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Instance is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(k_Instance, value);
    }

    public boolean hasInstance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Instance);
    }

    public PDFText getDataAsTextString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.getInstance(this.getDictionaryCosObjectValue(k_Data));
    }

    public void setDataAsTextString(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Settings is a required key therefore cannot be removed.");
        }
        this.setDictionaryTextValue(k_Data, value);
    }

    public PDFStream getDataAsStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStream.getInstance(this.getDictionaryCosObjectValue(k_Data));
    }

    public void setDataAsStream(PDFStream value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("Data is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(k_Data, value);
    }

    public boolean hasData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Data);
    }
}

