/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaWindow;

public class PDFRichMediaPresentation
extends PDFCosDictionary {
    public static final ASName k_RichMediaPresentation = ASName.create("RichMediaPresentation");
    public static final ASName k_Style = ASName.create("Style");
    public static final ASName k_Window = ASName.create("Window");
    public static final ASName k_Transparent = ASName.create("Transparent");
    public static final ASName k_NavigationPane = ASName.create("NavigationPane");
    public static final ASName k_Toolbar = ASName.create("Toolbar");
    public static final ASName k_PassContextClick = ASName.create("PassContextClick");
    public static final ASName k_Windowed = ASName.create("Windowed");
    public static final ASName k_Embedded = ASName.create("Embedded");

    private PDFRichMediaPresentation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaPresentation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaPresentation pdfObject = new PDFRichMediaPresentation(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaPresentation getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaPresentation pdfObject = (PDFRichMediaPresentation)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaPresentation.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaPresentation(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaPresentation)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + k_RichMediaPresentation + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Style);
    }

    public void setStyle(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Style);
        } else if (value.equals(k_Embedded) || value.equals(k_Windowed)) {
            this.setDictionaryNameValue(ASName.k_Style, value);
        } else {
            throw new PDFInvalidParameterException("Style value is out of bound.");
        }
    }

    public boolean hasStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Style);
    }

    public PDFRichMediaWindow getWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaWindow.getInstance(this.getDictionaryCosObjectValue(k_Window));
    }

    public void setWindow(PDFRichMediaWindow value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Window, value);
    }

    public boolean hasWindow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Window);
    }

    public boolean getTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_Transparent);
    }

    public void setTransparent(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_Transparent, value);
    }

    public boolean hasTransparent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Transparent);
    }

    public boolean getNavigationPane() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_NavigationPane);
    }

    public void setNavigationPane(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_NavigationPane, value);
    }

    public boolean hasNavigationPane() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_NavigationPane);
    }

    public boolean getToolbar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_Toolbar);
    }

    public void setToolbar(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_Toolbar, value);
    }

    public boolean hasToolbar() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Toolbar);
    }

    public boolean getPassContextClick() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryBooleanValue(k_PassContextClick);
    }

    public void setPassContextClick(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_PassContextClick, value);
    }

    public boolean hasPassContextClick() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_PassContextClick);
    }
}

