/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaAnimation;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaConfiguration;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaPresentation;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaView;

public class PDFRichMediaActivation
extends PDFCosDictionary {
    public static final ASName k_Condition = ASName.create("Condition");
    public static final ASName k_Animation = ASName.create("Animation");
    public static final ASName k_View = ASName.create("View");
    public static final ASName k_Configuration = ASName.create("Configuration");
    public static final ASName k_Presentation = ASName.create("Presentation");
    public static final ASName k_Scripts = ASName.create("Scripts");
    public static final ASName k_RichMediaActivation = ASName.create("RichMediaActivation");
    public static final ASName k_XA = ASName.create("XA");
    public static final ASName k_PO = ASName.create("PO");
    public static final ASName k_PV = ASName.create("PV");

    private PDFRichMediaActivation(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRichMediaActivation newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFRichMediaActivation pdfObject = new PDFRichMediaActivation(cosObject);
        return pdfObject;
    }

    public static PDFRichMediaActivation getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRichMediaActivation pdfObject = (PDFRichMediaActivation)PDFCosObject.getCachedInstance(cosObject, PDFRichMediaActivation.class);
        if (pdfObject == null) {
            pdfObject = new PDFRichMediaActivation(cosObject);
        }
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public void setType(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(ASName.k_Type);
        } else if (value.equals(k_RichMediaActivation)) {
            this.setDictionaryNameValue(ASName.k_Type, value);
        } else {
            throw new PDFInvalidParameterException("Type value is not valid. " + k_RichMediaActivation + " is expected.");
        }
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASName getCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(k_Condition);
    }

    public void setCondition(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            this.removeValue(k_Condition);
        } else if (value.equals(k_XA) || value.equals(k_PO) || value.equals(k_PV)) {
            this.setDictionaryNameValue(k_Condition, value);
        } else {
            throw new PDFInvalidParameterException("Condition value is out of bound.");
        }
    }

    public boolean hasCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Condition);
    }

    public PDFRichMediaAnimation getAnimation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaAnimation.getInstance(this.getDictionaryCosObjectValue(k_Animation));
    }

    public void setAnimation(PDFRichMediaAnimation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Animation, value);
    }

    public boolean hasAnimation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Animation);
    }

    public PDFRichMediaView getView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaView.getInstance(this.getDictionaryCosObjectValue(k_View));
    }

    public void setView(PDFRichMediaView value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_View, value);
    }

    public boolean hasView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_View);
    }

    public PDFRichMediaConfiguration getConfiguration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaConfiguration.getInstance(this.getDictionaryCosObjectValue(k_Configuration));
    }

    public void setConfiguration(PDFRichMediaConfiguration value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Configuration, value);
    }

    public boolean hasConfiguration() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Configuration);
    }

    public PDFRichMediaPresentation getPresentation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRichMediaPresentation.getInstance(this.getDictionaryCosObjectValue(k_Presentation));
    }

    public void setPresentation(PDFRichMediaPresentation value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Presentation, value);
    }

    public boolean hasPresentation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Presentation);
    }

    public PDFFileSpecificationList getScripts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryValue(k_Scripts);
        return PDFFileSpecificationList.getInstance(cosObject);
    }

    public void setScripts(PDFFileSpecificationList value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_Scripts, value);
    }

    public boolean hasScripts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_Scripts);
    }
}

