/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRendition;

public class PDFRenditionSelector
extends PDFRendition {
    private PDFRenditionSelector(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFRenditionSelector getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFRenditionSelector pdfObject = (PDFRenditionSelector)PDFCosObject.getCachedInstance(cosObject, PDFRenditionSelector.class);
        if (pdfObject == null) {
            pdfObject = new PDFRenditionSelector(cosObject);
        }
        return pdfObject;
    }

    public Iterator iterator() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return new Iterator();
    }

    public class Iterator {
        java.util.Iterator iterator;

        public Iterator() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
            CosArray array = PDFRenditionSelector.this.getDictionaryArrayValue(ASName.k_R);
            this.iterator = array.iterator();
        }

        public void remove() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.iterator.remove();
        }

        public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return this.iterator.hasNext();
        }

        public PDFRendition next() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            return PDFRendition.getInstance((CosObject)this.iterator.next());
        }
    }
}

