/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaOffset;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFTimespan;

public class PDFMediaOffsetTime
extends PDFMediaOffset {
    private PDFMediaOffsetTime(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFMediaOffsetTime newInstance(PDFDocument pdfDocument, PDFTimespan key_T) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_T == null) {
            throw new PDFInvalidParameterException("T is required when creating newInstance of PDFMediaOffsetTime.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFMediaOffsetTime pdfObject = new PDFMediaOffsetTime(cosObject);
        pdfObject.setType();
        pdfObject.setSubtype();
        pdfObject.setT(key_T);
        return pdfObject;
    }

    public static PDFMediaOffsetTime getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFMediaOffsetTime pdfObject = (PDFMediaOffsetTime)PDFCosObject.getCachedInstance(cosObject, PDFMediaOffsetTime.class);
        if (pdfObject == null) {
            pdfObject = new PDFMediaOffsetTime(cosObject);
        }
        return pdfObject;
    }

    @Override
    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    private void setType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_MediaOffset);
    }

    @Override
    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    @Override
    public ASName getSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_S);
    }

    private void setSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, ASName.k_T);
    }

    @Override
    public ASName requireSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.getDictionaryNameValue(ASName.k_S);
        if (name == null) {
            throw new PDFInvalidDocumentException("Unable to get Subtype.");
        }
        return name;
    }

    @Override
    public boolean hasSubtype() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_S);
    }

    public PDFTimespan getT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFTimespan.getInstance(this.getDictionaryCosObjectValue(ASName.k_T));
    }

    public void setT(PDFTimespan value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value == null) {
            throw new PDFInvalidParameterException("T is a required key therefore cannot be removed.");
        }
        this.setDictionaryValue(ASName.k_T, value);
    }

    public PDFTimespan requireT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTimespan pdfObject = PDFTimespan.getInstance(this.getDictionaryCosObjectValue(ASName.k_T));
        if (pdfObject == null) {
            throw new PDFInvalidDocumentException("Could not get T");
        }
        return pdfObject;
    }

    public boolean hasT() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }
}

