/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.multimedia;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;

public class PDF3DMeasurementList
extends PDFCosArrayList<PDF3DMeasurement> {
    private PDF3DMeasurementList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDF3DMeasurementList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDF3DMeasurementList pdfObject = (PDF3DMeasurementList)PDFCosObject.getCachedInstance(cosObject, PDF3DMeasurementList.class);
        if (pdfObject == null) {
            pdfObject = new PDF3DMeasurementList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDF3DMeasurement itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDF3DMeasurement.getInstance(cosObject);
    }

    public static PDF3DMeasurementList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDF3DMeasurementList pdfObject = new PDF3DMeasurementList(cosObject);
        return pdfObject;
    }

    public static PDF3DMeasurementList newInstance(PDFDocument pdfDocument, PDF3DMeasurementList configs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (configs.size() > 0) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, configs);
            return new PDF3DMeasurementList(cosObject);
        }
        return PDF3DMeasurementList.newInstance(pdfDocument);
    }
}

