/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.structure;

public enum PDFStructureType {
    Array(1),
    Element(2),
    MCID(4),
    MCR(8),
    OBJR(16),
    Root(32),
    PageContent(MCID.getValue() | MCR.getValue() | OBJR.getValue());

    private final int type;

    private PDFStructureType(int type) {
        this.type = type;
    }

    private int getValue() {
        return this.type;
    }

    public boolean equals(PDFStructureType otherType) {
        return otherType.getValue() == this.type;
    }

    public boolean contains(PDFStructureType otherType) {
        return (otherType.getValue() & this.type) != 0;
    }
}

