/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionUtil;

public class PDFCollectionColors
extends PDFCosDictionary {
    private PDFCollectionColors(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionColors getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionColors pdfObject = (PDFCollectionColors)PDFCosObject.getCachedInstance(cosObject, PDFCollectionColors.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionColors(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionColors newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFCollectionColors(cosObject);
    }

    public double[] getBackground() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionUtil.getColor(ASName.k_Background, this);
    }

    public void setBackground(double[] background) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionUtil.setColor(background, ASName.k_Background, this);
    }

    public boolean hasBackground() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Background);
    }

    public double[] getCardBackground() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionUtil.getColor(ASName.k_CardBackground, this);
    }

    public void setCardBackground(double[] cardBackground) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionUtil.setColor(cardBackground, ASName.k_CardBackground, this);
    }

    public boolean hasCardBackground() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CardBackground);
    }

    public double[] getCardBorder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionUtil.getColor(ASName.k_CardBorder, this);
    }

    public void setCardBorder(double[] cardBorder) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionUtil.setColor(cardBorder, ASName.k_CardBorder, this);
    }

    public boolean hasCardBorder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_CardBorder);
    }

    public double[] getPrimaryText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionUtil.getColor(ASName.k_PrimaryText, this);
    }

    public void setPrimaryText(double[] primaryText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionUtil.setColor(primaryText, ASName.k_PrimaryText, this);
    }

    public boolean hasPrimaryText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PrimaryText);
    }

    public double[] getSecondaryText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionUtil.getColor(ASName.k_SecondaryText, this);
    }

    public void setSecondaryText(double[] secondaryText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCollectionUtil.setColor(secondaryText, ASName.k_SecondaryText, this);
    }

    public boolean hasSecondaryText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SecondaryText);
    }
}

