/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.ArrayList;

public final class PDFIconFit
extends PDFCosDictionary {
    public static final ASName k_SW = ASName.create("SW");
    public static final ASName k_FB = ASName.create("FB");

    private PDFIconFit(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFIconFit getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFIconFit pdfObject = (PDFIconFit)PDFCosObject.getCachedInstance(cosObject, PDFIconFit.class);
        if (pdfObject == null) {
            pdfObject = new PDFIconFit(cosObject);
        }
        return pdfObject;
    }

    public static PDFIconFit newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFIconFit(cosObject);
    }

    public IconScaleCondition getIconScaleCondition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.containsKey(k_SW)) {
            return IconScaleCondition.ALWAYS;
        }
        return IconScaleCondition.getInstance(this.getDictionaryNameValue(k_SW));
    }

    public void setIconScaleCondition(IconScaleCondition condition) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_SW, condition == null ? null : condition.getValue());
    }

    public IconScaleType getIconScaleType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.containsKey(ASName.k_S)) {
            return IconScaleType.PROPORTIONAL;
        }
        return IconScaleType.getInstance(this.getDictionaryNameValue(ASName.k_S));
    }

    public void setIconScaleType(IconScaleType type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_S, type == null ? null : type.getValue());
    }

    public double[] getIconScalePosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.containsKey(ASName.k_A)) {
            return new double[]{0.5, 0.5};
        }
        Object scalePositions = this.getDictionaryArrayValue(ASName.k_A).getValue();
        if (((ArrayList)scalePositions).size() != 2) {
            throw new PDFInvalidDocumentException("Scale Positon array size is not 2.");
        }
        return new double[]{((Number)((ArrayList)scalePositions).get(0)).doubleValue(), ((Number)((ArrayList)scalePositions).get(1)).doubleValue()};
    }

    public double getScalePositionX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getIconScalePosition()[0];
    }

    public double getScalePositionY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getIconScalePosition()[1];
    }

    public void setIconScalePosition(double[] pos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pos != null && pos.length != 2) {
            throw new PDFInvalidParameterException("Scale Positon array size is not 2.");
        }
        this.setDictionaryArrayValue(ASName.k_A, pos);
    }

    public void setScalePositionX(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosValue = this.getPDFDocument().getCosDocument().createCosNumeric(value);
        if (this.containsKey(ASName.k_A)) {
            this.getDictionaryArrayValue(ASName.k_A).set(0, cosValue);
        } else {
            this.setDictionaryArrayValue(ASName.k_A, new double[]{value, 0.5});
        }
    }

    public void setScalePositionY(double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric cosValue = this.getPDFDocument().getCosDocument().createCosNumeric(value);
        if (this.containsKey(ASName.k_A)) {
            this.getDictionaryArrayValue(ASName.k_A).set(1, cosValue);
        } else {
            this.setDictionaryArrayValue(ASName.k_A, new double[]{0.5, value});
        }
    }

    public boolean getScaleFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.dictionaryContains(k_FB)) {
            return this.getDictionaryBooleanValue(k_FB);
        }
        return false;
    }

    public void setScaleFit(Boolean type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(k_FB, type);
    }

    public static enum IconScaleType {
        ANAMORPHIC(ASName.k_A),
        PROPORTIONAL(ASName.k_P);

        private ASName value;

        public static IconScaleType getInstance(ASName value) {
            if (value == ASName.k_A) {
                return ANAMORPHIC;
            }
            if (value == ASName.k_P) {
                return PROPORTIONAL;
            }
            return null;
        }

        private IconScaleType(ASName value) {
            this.value = value;
        }

        public ASName getValue() {
            return this.value;
        }
    }

    public static enum IconScaleCondition {
        ALWAYS(ASName.k_A),
        SCALE_WHEN_BIG(ASName.k_B),
        SCALE_WHEN_SMALL(ASName.k_S),
        NEVER_SCALE(ASName.k_N);

        private ASName value;

        public static IconScaleCondition getInstance(ASName value) {
            if (value == ASName.k_A) {
                return ALWAYS;
            }
            if (value == ASName.k_B) {
                return SCALE_WHEN_BIG;
            }
            if (value == ASName.k_S) {
                return SCALE_WHEN_SMALL;
            }
            if (value == ASName.k_N) {
                return NEVER_SCALE;
            }
            return null;
        }

        private IconScaleCondition(ASName value) {
            this.value = value;
        }

        public ASName getValue() {
            return this.value;
        }
    }
}

