/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFAnnotationRichMedia
extends PDFAnnotation {
    public static final ASName k_RichMediaSettings = ASName.create("RichMediaSettings");
    public static final ASName k_RichMediaContent = ASName.create("RichMediaContent");

    private PDFAnnotationRichMedia(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationRichMedia getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationRichMedia pdfObject = (PDFAnnotationRichMedia)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationRichMedia.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationRichMedia(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationRichMedia(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_RichMedia);
    }

    public static PDFAnnotationRichMedia newInstance(PDFDocument pdfDocument, PDFRectangle location, PDFCosDictionary richMediaContent) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        PDFAnnotationRichMedia pdfObject = new PDFAnnotationRichMedia(pdfDocument);
        pdfObject.setRect(location);
        pdfObject.setRichMediaContent(richMediaContent);
        return pdfObject;
    }

    public PDFCosDictionary getRichMediaContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFRichMediaContent", this.getDictionaryCosObjectValue(k_RichMediaContent));
    }

    public void setRichMediaContent(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(k_RichMediaContent, value);
    }

    public boolean hasRichMediaContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_RichMediaContent);
    }

    public PDFCosDictionary getRichMediaSettings() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMultimediaUtil.createPDFMultimediaObject("PDFRichMediaSettings", this.getDictionaryCosObjectValue(k_RichMediaSettings));
    }

    public void setRichMediaSettings(PDFCosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFMultimediaUtil.checkParameterType("com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRichMediaSettings", value);
        this.setDictionaryValue(k_RichMediaSettings, value);
    }

    public boolean hasRichMediaSettings() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(k_RichMediaSettings);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

