/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFileInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIcon;

public class PDFAnnotationFileAttachment
extends PDFAnnotationMarkup
implements PDFAnnotationWithIcon {
    private PDFAnnotationFileAttachment(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    @Override
    public void setIconName(String icon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, icon);
    }

    @Override
    public String getIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryValue(ASName.k_Name);
        if (obj instanceof CosName) {
            return this.getDictionaryNameValue(ASName.k_Name).asString(true);
        }
        ASString asStr = this.getDictionaryStringValue(ASName.k_Name);
        return asStr != null ? asStr.asString() : null;
    }

    @Override
    public boolean hasIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Name);
    }

    public static PDFAnnotationFileAttachment getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationFileAttachment pdfObject = (PDFAnnotationFileAttachment)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationFileAttachment.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationFileAttachment(cosObject);
        }
        return pdfObject;
    }

    public static PDFAnnotationFileAttachment newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationFileAttachment(pdfDocument);
    }

    private PDFAnnotationFileAttachment(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_FileAttachment);
    }

    public static PDFAnnotationFileAttachment newInstance(PDFDocument pdfDocument, PDFRectangle location, PDFFileSpecification embeddedFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAnnotationFileAttachment pdfObject = PDFAnnotationFileAttachment.newInstance(pdfDocument);
        pdfObject.setRect(location);
        pdfObject.setFileSpecification(embeddedFile);
        return pdfObject;
    }

    public void setFileSpecification(PDFFileSpecification embeddedFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (embeddedFile == null) {
            throw new PDFInvalidParameterException("File specification can't be null");
        }
        this.getCosDictionary().put(ASName.k_FS, embeddedFile.getCosObject());
    }

    public boolean hasFileSpecification() {
        return this.getCosDictionary().containsKey(ASName.k_FS);
    }

    public PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification fileSpec = PDFFileSpecification.getInstance(this.getDictionaryCosObjectValue(ASName.k_FS));
        return fileSpec;
    }

    public PDFFileSpecification requireFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification fileSpec = this.getFileSpecification();
        if (fileSpec == null) {
            throw new PDFInvalidDocumentException("Required file specification was null.");
        }
        return fileSpec;
    }

    public PDFFileSpecification procureFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasFileSpecification()) {
            return this.getFileSpecification();
        }
        ASString nullName = new ASString("");
        return PDFFileSpecification.newInstance(this.getPDFDocument(), nullName, null);
    }

    public PDFEmbeddedFileInfo procureFileInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.procureFileSpecification().procureEmbeddedFile().procureFileInfo();
    }

    public void setFileInfo(PDFEmbeddedFileInfo fileInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFileSpecification fileSpec = this.procureFileSpecification();
        PDFEmbeddedFile embedded = fileSpec.procureEmbeddedFile();
        embedded.setFileInfo(fileInfo);
        fileSpec.setEmbeddedFile(embedded);
        this.setFileSpecification(fileSpec);
    }

    public void setEmbeddedFile(PDFEmbeddedFile embedded) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFileSpecification fileSpec = this.procureFileSpecification();
        fileSpec.setEmbeddedFile(embedded);
        this.setFileSpecification(fileSpec);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

