/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.inlineimage;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;

public class InlineImageColorSpace {
    private static final int t_name_device_cs = 0;
    private static final int t_name_existing_resource_cs = 1;
    private static final int t_array_indexed_cs = 2;
    private static final int t_new_resource_cs = 3;
    private int csType;
    private ASName csName;
    private ASArray csArray;
    private PDFColorSpace newResourceCS;
    private boolean BlackIs1;
    private boolean isImageInverted;

    InlineImageColorSpace(ASName csName) {
        this.csType = csName == ASName.k_DeviceRGB || csName == ASName.k_DeviceCMYK || csName == ASName.k_DeviceGray || csName == ASName.k_G || csName == ASName.k_CMYK || csName == ASName.k_RGB ? 0 : 1;
        this.csName = csName;
    }

    InlineImageColorSpace(ASArray csArray) {
        this.csType = 2;
        this.csArray = csArray;
    }

    InlineImageColorSpace(PDFColorSpace cs) {
        this.csType = 3;
        this.newResourceCS = cs;
    }

    static InlineImageColorSpace createFromNameOrArray(Object cs) {
        if (cs instanceof ASName) {
            return new InlineImageColorSpace((ASName)cs);
        }
        if (cs instanceof ASArray) {
            return new InlineImageColorSpace((ASArray)cs);
        }
        return null;
    }

    boolean isName() {
        return this.csType == 0 || this.csType == 1;
    }

    boolean isArray() {
        return this.csType == 2;
    }

    public ASName getName() throws PDFInvalidContentException {
        if (this.isName()) {
            return this.csName;
        }
        if (this.isArray()) {
            try {
                return this.csArray.getName(0);
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidContentException("Invalid Color Space Array", e);
            }
        }
        return null;
    }

    public boolean isDeviceColorSpace() {
        return this.csType == 0;
    }

    public ASName getDeviceColorSpaceName() {
        if (this.isDeviceColorSpace()) {
            if (this.csName == ASName.k_G) {
                return ASName.k_DeviceGray;
            }
            if (this.csName == ASName.k_RGB) {
                return ASName.k_DeviceRGB;
            }
            if (this.csName == ASName.k_CMYK) {
                return ASName.k_DeviceCMYK;
            }
            return this.csName;
        }
        return null;
    }

    public void setDeviceColorSpaceName(ASName deviceCSName) throws PDFInvalidParameterException {
        if (deviceCSName != ASName.k_DeviceRGB && deviceCSName != ASName.k_DeviceCMYK && deviceCSName != ASName.k_DeviceGray) {
            throw new PDFInvalidParameterException("Device color space name must be DeviceRGB, DeviceCMYK, or DeviceGray");
        }
        this.csType = 0;
        this.csName = deviceCSName;
        this.csArray = null;
        this.newResourceCS = null;
    }

    public void setDeviceColorSpace(PDFColorSpace deviceCS) throws PDFInvalidParameterException {
        if (!(deviceCS instanceof PDFColorSpaceDeviceRGB || deviceCS instanceof PDFColorSpaceDeviceCMYK || deviceCS instanceof PDFColorSpaceDeviceGray)) {
            throw new PDFInvalidParameterException("Device color space must be PDFColorSpaceDeviceRGB, PDFColorSpaceDeviceCMYK, or PDFColorSpaceDeviceGray");
        }
        this.csType = 0;
        this.csName = deviceCS.getName();
        this.csArray = null;
        this.newResourceCS = null;
    }

    public boolean isExistingResourceColorSpaceName() {
        return this.csType == 1;
    }

    public ASName getExistingResourceColorSpaceName() {
        return this.isExistingResourceColorSpaceName() ? this.csName : null;
    }

    public void setExistingResourceColorSpaceName(ASName csResourceName) {
        this.csType = 1;
        this.csName = csResourceName;
        this.csArray = null;
        this.newResourceCS = null;
    }

    public boolean isNewResourceColorSpace() {
        return this.csType == 3;
    }

    public PDFColorSpace getNewResourceColorSpace() {
        return this.isNewResourceColorSpace() ? this.newResourceCS : null;
    }

    public void setNewResourceColorSpace(PDFColorSpace cs) throws PDFInvalidParameterException {
        this.csType = 3;
        this.newResourceCS = cs;
        this.csName = null;
        this.csArray = null;
    }

    public boolean isIndexedColorSpace() throws PDFInvalidContentException {
        ASName csName = null;
        return this.isArray() && this.csArray.size() == 4 && (ASName.k_Indexed == (csName = this.getName()) || ASName.k_I == csName);
    }

    public ASArray getIndexedColorSpace() throws PDFInvalidContentException {
        return this.isIndexedColorSpace() ? this.csArray : null;
    }

    public InlineImageColorSpace getIndexedColorSpaceBase() throws PDFInvalidContentException {
        return this.isIndexedColorSpace() ? InlineImageColorSpace.createFromNameOrArray(this.csArray.get(1)) : null;
    }

    public ColorModel createColorModel(int bpc, PDFResources currentResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDeviceColorSpace()) {
            ASName csName = this.getDeviceColorSpaceName();
            if (csName == ASName.k_DeviceRGB) {
                int[] nbBits = new int[]{bpc, bpc, bpc};
                return new ComponentColorModel(this.createColorSpace(currentResources), nbBits, false, false, 1, 0);
            }
            if (csName == ASName.k_DeviceCMYK) {
                int[] nbBits = new int[]{bpc, bpc, bpc, bpc};
                return new ComponentColorModel(this.createColorSpace(currentResources), nbBits, false, false, 1, 0);
            }
            if (csName == ASName.k_DeviceGray) {
                if (bpc == 2) {
                    boolean inverted;
                    byte[] gray = new byte[4];
                    boolean bl = inverted = this.isBlackIs1() || this.isImageInverted();
                    if (inverted) {
                        for (int i = 0; i < 4; ++i) {
                            gray[i] = (byte)(255 - i * 85);
                        }
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            gray[i] = (byte)(i * 85);
                        }
                    }
                    return new IndexColorModel(2, 4, gray, gray, gray);
                }
                if (bpc == 1) {
                    boolean inverted;
                    int a = -1;
                    byte[] gray = new byte[2];
                    boolean bl = inverted = this.isBlackIs1() || this.isImageInverted();
                    if (inverted) {
                        gray[0] = a;
                        gray[1] = 0;
                    } else {
                        gray[0] = 0;
                        gray[1] = a;
                    }
                    return new IndexColorModel(1, 2, gray, gray, gray);
                }
                if (bpc == 4) {
                    boolean inverted;
                    byte[] gray = new byte[16];
                    boolean bl = inverted = this.isBlackIs1() || this.isImageInverted();
                    if (inverted) {
                        for (int i = 0; i < 16; ++i) {
                            gray[i] = (byte)(255 - i * 17);
                        }
                    } else {
                        for (int i = 0; i < 16; ++i) {
                            gray[i] = (byte)(i * 17);
                        }
                    }
                    return new IndexColorModel(4, 16, gray, gray, gray);
                }
                ColorSpace cs = ColorSpace.getInstance(1003);
                int[] nBits = new int[]{bpc};
                return new ComponentColorModel(cs, nBits, false, false, 1, 0);
            }
        } else {
            if (this.isIndexedColorSpace()) {
                int size;
                ASArray csArray = this.getIndexedColorSpace();
                try {
                    size = csArray.getNumber(2).intValue();
                }
                catch (PDFUnableToCompleteOperationException e) {
                    throw new PDFInvalidContentException(e);
                }
                byte[] data = null;
                ASString lookupTable = (ASString)csArray.get(3);
                data = lookupTable == null ? new byte[]{} : lookupTable.getBytes();
                return new IndexColorModel(bpc, size + 1, data, 0, false);
            }
            if (this.isExistingResourceColorSpaceName() || this.isNewResourceColorSpace()) {
                PDFColorSpace cs = null;
                if (this.isExistingResourceColorSpaceName() && currentResources != null) {
                    ASName csName = this.getExistingResourceColorSpaceName();
                    cs = currentResources.getColorSpace(csName);
                } else if (this.isNewResourceColorSpace()) {
                    cs = this.getNewResourceColorSpace();
                }
                if (cs != null) {
                    return cs.createColorModel(bpc, 0);
                }
            }
        }
        throw new PDFInvalidDocumentException("Could not determine the color space used by the inline image.");
    }

    public ColorSpace createColorSpace(PDFResources currentResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDeviceColorSpace()) {
            ASName csName = this.getDeviceColorSpaceName();
            if (csName == ASName.k_DeviceRGB) {
                return ColorSpace.getInstance(1000);
            }
            if (csName == ASName.k_DeviceCMYK) {
                throw new PDFUnsupportedFeatureException("Cannot create a color space for DeviceCMYK");
            }
            if (csName == ASName.k_DeviceGray) {
                return ColorSpace.getInstance(1003);
            }
        } else {
            if (this.isIndexedColorSpace()) {
                return ColorSpace.getInstance(1000);
            }
            if (this.isExistingResourceColorSpaceName() || this.isNewResourceColorSpace()) {
                PDFColorSpace cs = null;
                if (this.isExistingResourceColorSpaceName() && currentResources != null) {
                    ASName csName = this.getExistingResourceColorSpaceName();
                    cs = currentResources.getColorSpace(csName);
                } else if (this.isNewResourceColorSpace()) {
                    cs = this.getNewResourceColorSpace();
                }
                if (cs != null) {
                    return cs.createColorSpace();
                }
            }
        }
        throw new PDFInvalidDocumentException("Could not determine the color space used by the inline image.");
    }

    public boolean isBlackIs1() {
        return this.BlackIs1;
    }

    public void setBlackIs1(boolean blackIs1) {
        this.BlackIs1 = blackIs1;
    }

    public boolean isImageInverted() {
        return this.isImageInverted;
    }

    public void setImageInverted(boolean isImageInverted) {
        this.isImageInverted = isImageInverted;
    }
}

