/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.shading;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunction;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFFunctionsArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMeshes;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingType;

public class PDFShadingLattice
extends PDFShadingMeshes {
    private PDFShadingLattice(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    private PDFShadingLattice(PDFDocument pdfDocument, int key_BitsPerComponent, CosArray key_Decode, int key_BitsPerCoordinate, int key_VerticesPerRow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(PDFCosObject.newCosStream(pdfDocument));
        this.setBitsPerComponent(key_BitsPerComponent);
        this.setDecode(key_Decode);
        this.setShadingType(PDFShadingType.SHADING_TYPE_LATTICE.getValue());
        this.setBitsPerCoordinate(key_BitsPerCoordinate);
        this.setVerticesPerRow(key_VerticesPerRow);
    }

    public static PDFShadingLattice newInstance(PDFDocument pdfDocument, int key_BitsPerComponent, CosArray key_Decode, int key_BitsPerCoordinate, int key_VerticesPerRow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_Decode == null) {
            throw new PDFInvalidParameterException("Decode is required when creating newInstance of PDFShadingLattice.");
        }
        return new PDFShadingLattice(pdfDocument, key_BitsPerComponent, key_Decode, key_BitsPerCoordinate, key_VerticesPerRow);
    }

    public static PDFShadingLattice getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFShadingLattice pdfObject = (PDFShadingLattice)PDFCosObject.getCachedInstance(cosObject, PDFShadingLattice.class);
        if (pdfObject == null) {
            pdfObject = new PDFShadingLattice(cosObject);
        }
        return pdfObject;
    }

    public void setFunctionArray(PDFFunction value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(value, false);
    }

    public void setFunctionArray(PDFFunctionsArray children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setFunctionArray(children, false);
    }

    public int getVerticesPerRow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_VerticesPerRow);
    }

    public void setVerticesPerRow(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_VerticesPerRow, value);
    }

    public int requireVerticesPerRow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_VerticesPerRow);
        if (cosObject == null) {
            throw new PDFInvalidDocumentException("Unable to get VerticesPerRow.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasVerticesPerRow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VerticesPerRow);
    }
}

