/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.patterns;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternFactory;

public class PDFPatternMap
extends PDFCosDictionaryMap<PDFPattern> {
    private PDFPatternMap(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPatternMap getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPatternMap pdfObject = (PDFPatternMap)PDFCosObject.getCachedInstance(cosObject, PDFPatternMap.class);
        if (pdfObject == null) {
            pdfObject = new PDFPatternMap(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFPattern itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPatternFactory.getInstance(cosObject);
    }

    public static PDFPatternMap newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFPatternMap pdfObject = new PDFPatternMap(cosObject);
        return pdfObject;
    }

    public PDFPattern get(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (super.containsKey(name)) {
            return (PDFPattern)super.get(name);
        }
        return null;
    }

    public void set(ASName name, PDFPattern pattern) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(name, pattern.getPDFCosObject());
    }
}

