/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.NoopOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ConditionalContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;

public class PDFCharProcs
extends PDFCosDictionaryMap<PDFContents> {
    private PDFCharProcs(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCharProcs getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCharProcs pdfObject = (PDFCharProcs)PDFCosObject.getCachedInstance(cosObject, PDFCharProcs.class);
        if (pdfObject == null) {
            pdfObject = new PDFCharProcs(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFContents itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFContents.getInstance(cosObject);
    }

    public void set(ASName name, PDFContents charProc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = charProc.getCosObject();
        if (cosObj instanceof CosArray) {
            InputByteStream data = charProc.getContents();
            super.put(name, PDFContents.getInstance(PDFCharProcs.newCosStream(this.getPDFDocument(), data)));
        } else {
            super.put(name, charProc);
        }
    }

    public double getWidth(ASName name) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double width = 0.0;
        PDFContents charProcStm = (PDFContents)this.get(name);
        if (charProcStm == null) {
            return width;
        }
        WidthHandler handler = new WidthHandler(false);
        ConditionalContentStreamProcessor proc = new ConditionalContentStreamProcessor(handler);
        proc.process(Content.newInstance(charProcStm, null));
        return handler.getWidth();
    }

    public double getCTMScaledWidth(ASName name) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double width = 0.0;
        PDFContents charProcStm = (PDFContents)this.get(name);
        if (charProcStm == null) {
            return width;
        }
        WidthHandler handler = new WidthHandler(true);
        ConditionalContentStreamProcessor proc = new ConditionalContentStreamProcessor(handler);
        proc.process(Content.newInstance(charProcStm, null));
        return handler.getWidth();
    }

    private class WidthHandler
    extends NoopOperatorHandler {
        private double width = 0.0;
        private boolean ctmScaledWidth;
        private boolean continueProcessing;

        public WidthHandler(boolean ctmScaledWidth) {
            this.ctmScaledWidth = ctmScaledWidth;
            this.continueProcessing = true;
        }

        public double getWidth() {
            return this.width;
        }

        @Override
        public boolean continueProcesing() {
            return this.continueProcessing;
        }

        @Override
        public void d0(double wx, double wy, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.width = wx;
            if (!this.ctmScaledWidth) {
                this.continueProcessing = false;
            }
        }

        @Override
        public void d1(double wx, double wy, double llx, double lly, double urx, double ury, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            this.width = wx;
            if (!this.ctmScaledWidth) {
                this.continueProcessing = false;
            }
        }

        @Override
        public void cm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.ctmScaledWidth) {
                this.width *= a;
            }
        }

        @Override
        public void BI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            if (this.ctmScaledWidth) {
                this.continueProcessing = false;
            }
        }
    }
}

