/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.DisplacementEntry;
import java.util.HashSet;
import java.util.Iterator;

public class PDFCIDVerticalMetrics
extends PDFCosObject {
    private HashSet<DisplacementEntry> metrics;
    private int cachedCID;
    private DisplacementEntry cachedEntry;
    private boolean isCIDCached = false;

    private PDFCIDVerticalMetrics(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
        this.buildMetricsTable();
    }

    public static PDFCIDVerticalMetrics getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCIDVerticalMetrics pdfObject = (PDFCIDVerticalMetrics)PDFCosObject.getCachedInstance(cosObject, PDFCIDVerticalMetrics.class);
        if (pdfObject == null) {
            pdfObject = new PDFCIDVerticalMetrics(cosObject);
        }
        return pdfObject;
    }

    public boolean containsMetric(int cid) {
        return this.getEntry(cid) != null;
    }

    public double[] getMetrics(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        DisplacementEntry entry = this.getEntry(cid);
        if (entry != null) {
            return entry.getMetrics(cid);
        }
        return null;
    }

    public double getVerticalDisplacement(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        DisplacementEntry entry = this.getEntry(cid);
        if (entry != null) {
            return entry.getVerticalDisplacement(cid);
        }
        return 0.0;
    }

    public double[] getPositionVector(int cid) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        DisplacementEntry entry = this.getEntry(cid);
        if (entry != null) {
            return entry.getPositionVector(cid);
        }
        return null;
    }

    private DisplacementEntry getEntry(int cid) {
        if (this.isCIDCached && cid == this.cachedCID) {
            return this.cachedEntry;
        }
        for (DisplacementEntry entry : this.metrics) {
            if (!entry.contains(cid)) continue;
            this.cachedCID = cid;
            this.cachedEntry = entry;
            this.isCIDCached = true;
            return entry;
        }
        return null;
    }

    private void buildMetricsTable() {
        if (this.metrics == null) {
            this.metrics = new HashSet();
            Iterator<CosObject> iter = this.getCosArray().iterator();
            while (iter.hasNext()) {
                int startCID = ((CosNumeric)iter.next()).intValue();
                CosObject item = iter.next();
                if (item instanceof CosArray) {
                    this.metrics.add(new DisplacementEntry(startCID, (CosArray)item));
                    continue;
                }
                int endCID = ((CosNumeric)item).intValue();
                double w11y = ((CosNumeric)iter.next()).doubleValue();
                double v1x = ((CosNumeric)iter.next()).doubleValue();
                double v1y = ((CosNumeric)iter.next()).doubleValue();
                this.metrics.add(new DisplacementEntry(startCID, endCID, w11y, v1x, v1y));
            }
        }
    }
}

