/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceCIEBasedDictionary;

public abstract class PDFColorSpaceCIEBased
extends PDFColorSpace {
    protected PDFColorSpaceCIEBased(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    protected PDFColorSpaceCIEBasedDictionary getDictionary() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject obj;
        CosObject cosObj = this.getCosObject();
        if (cosObj instanceof CosArray && (obj = ((CosArray)cosObj).get(1)) instanceof CosDictionary) {
            return PDFColorSpaceCIEBasedDictionary.getInstance(obj);
        }
        throw new PDFInvalidDocumentException("CIE based color space with Object number:" + this.getCosObject().getObjNum() + "is invalid.");
    }

    protected double[] getWhitePoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray array = this.getDictionary().getDictionaryArrayValue(ASName.k_WhitePoint);
        return array == null ? null : array.getArrayDouble();
    }

    protected void setWhitePoint(double[] whitePoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (whitePoint == null) {
            throw new PDFInvalidParameterException("WhitePoint entry is required so cann't be null.");
        }
        this.getDictionary().setDictionaryArrayValue(ASName.k_WhitePoint, whitePoint);
    }

    protected double[] getBlackPoint() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosArray array = this.getDictionary().getDictionaryArrayValue(ASName.k_BlackPoint);
        if (array == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return array.getArrayDouble();
    }

    protected void setBlackPoint(double[] blackPoint) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.getDictionary().setDictionaryArrayValue(ASName.k_BlackPoint, blackPoint);
    }
}

