/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;

public enum PDFLineJoin {
    MITER_JOIN(0),
    ROUND_JOIN(1),
    BEVEL_JOIN(2);

    private final int lineJoin;

    private PDFLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
    }

    public String toString() {
        String lineJoinStr = null;
        switch (this.lineJoin) {
            case 0: {
                lineJoinStr = "miter join";
                break;
            }
            case 1: {
                lineJoinStr = "round join";
                break;
            }
            case 2: {
                lineJoinStr = "bevel join";
            }
        }
        return lineJoinStr;
    }

    int getValue() {
        return this.lineJoin;
    }

    public static final PDFLineJoin getInstance(int lineJoinValue) throws PDFInvalidParameterException {
        PDFLineJoin lineJoin = null;
        switch (lineJoinValue) {
            case 0: {
                lineJoin = MITER_JOIN;
                break;
            }
            case 1: {
                lineJoin = ROUND_JOIN;
                break;
            }
            case 2: {
                lineJoin = BEVEL_JOIN;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("illegal line join value");
            }
        }
        return lineJoin;
    }
}

