/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosNumeric;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.PDFFunctionUtils;

public class PDFDomain
extends PDFCosArrayList<PDFCosNumeric> {
    private PDFDomain(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFDomain getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFDomain pdfObject = (PDFDomain)PDFCosObject.getCachedInstance(cosObject, PDFDomain.class);
        if (pdfObject == null) {
            pdfObject = new PDFDomain(cosObject);
        }
        return pdfObject;
    }

    public static PDFDomain newInstance(PDFDocument pdfDocument, double[] domainArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFFunctionUtils.validateDomainORRangeArray(domainArray);
        CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, 0, domainArray, 0, domainArray.length - 1);
        PDFDomain pdfDomain = new PDFDomain(cosObject);
        return pdfDomain;
    }

    @Override
    protected PDFCosNumeric itemInstantiator(CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFCosNumeric.getInstance(cosObject);
    }
}

