/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document.listener;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistryBase;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GroupDocumentListener
extends DocumentListenerRegistryBase
implements DocumentListener {
    protected Object listenerKey;
    protected List<Object> listenerOrder;
    protected Object headListener;
    protected Object tailListener;

    protected GroupDocumentListener(PDFDocument pdfDocument, Object listenerKey) {
        super(pdfDocument);
        this.listenerKey = listenerKey;
        this.listenerOrder = new ArrayList<Object>();
    }

    public boolean registerListener(int position, Object listenerKey, DocumentListener listener) {
        boolean registered = super.registerListener(listenerKey, listener);
        if (registered) {
            this.insertListenerInQueue(position, listenerKey);
        }
        return registered;
    }

    @Override
    public boolean registerListener(Object listenerKey, DocumentListener listener) {
        return this.registerListener(Integer.MAX_VALUE, listenerKey, listener);
    }

    private void insertListenerInQueue(int position, Object listenerKey) {
        if (position == Integer.MIN_VALUE) {
            this.headListener = listenerKey;
        }
        if (position == Integer.MAX_VALUE) {
            this.tailListener = listenerKey;
        }
        if (position < 0) {
            position = 0;
            if (this.headListener != null && listenerKey != this.headListener) {
                position = 1;
            }
        } else if (position > this.listenerOrder.size()) {
            position = this.listenerOrder.size();
            if (this.tailListener != null && listenerKey != this.tailListener) {
                position = this.listenerOrder.size() - 1;
            }
        }
        this.listenerOrder.add(position, listenerKey);
    }

    private void removeListenerFromQueue(Object listenerKey) {
        this.listenerOrder.remove(listenerKey);
        if (this.headListener == listenerKey) {
            this.headListener = null;
        }
        if (this.tailListener == listenerKey) {
            this.tailListener = null;
        }
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return new DocumentListenerProperties();
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        super.sendMessage(message, false);
    }

    @Override
    protected void notifyListenerAdded(Object listenerKey, DocumentListenerRegistryBase.ListenerEntry entry) {
    }

    @Override
    protected void notifyListenerChanged(Object listnerKey, DocumentListenerRegistryBase.ListenerEntry entry) {
    }

    @Override
    protected Iterator<Object> getListenerIterator() {
        return this.listenerOrder.iterator();
    }

    @Override
    protected void notifyListenerRemoved(Object listenerKey, DocumentListenerRegistryBase.ListenerEntry entry) {
        this.removeListenerFromQueue(listenerKey);
    }

    @Override
    public boolean holdStrongly(Object listenerKey, boolean strongly) {
        boolean oldHoldStrongly = super.holdStrongly(listenerKey, strongly);
        if (oldHoldStrongly != strongly) {
            this.pdfDocument.getListenerRegistry().holdStrongly(this.listenerKey, super.isAnyListenerHeldStrongly());
        }
        return oldHoldStrongly;
    }

    @Override
    public boolean markDirty(Object listenerKey, boolean dirty) {
        boolean oldDirty = super.markDirty(listenerKey, dirty);
        if (oldDirty != dirty) {
            this.pdfDocument.getListenerRegistry().markDirty(this.listenerKey, super.isAnyListenerDirty());
        }
        return oldDirty;
    }
}

