/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeLeaf;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTreeNode;

public class PDFTreeList<K, V>
extends PDFCosArrayList<PDFTreeNode<K, V>> {
    private static final int kSplitNumber = 64;
    private ASName keyName;
    private PDFTreeNode<K, V> mParentNode = null;

    private PDFTreeList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static <K, V> PDFTreeList<K, V> getInstance(CosObject cosObject, PDFTreeNode<K, V> parent, ASName keyName) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTreeList<K, V> pdfTreeList = (PDFTreeList<K, V>)PDFCosObject.getCachedInstance(cosObject, PDFTreeList.class);
        if (pdfTreeList == null) {
            pdfTreeList = new PDFTreeList<K, V>(cosObject);
        }
        pdfTreeList.setKeyName(keyName);
        pdfTreeList.setParent(parent);
        return pdfTreeList;
    }

    static <K, V> PDFTreeList<K, V> newInstance(PDFDocument pdfDocument, PDFTreeNode<K, V> parent, ASName keyName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFTreeList<K, V> pdfObject = new PDFTreeList<K, V>(cosObject);
        pdfObject.setKeyName(keyName);
        pdfObject.setParent(parent);
        return pdfObject;
    }

    static <K, V> PDFTreeList<K, V> newInstance(PDFDocument pdfDocument, PDFTreeNode<K, V> parent, ASName keyName, PDFTreeNode<K, V> item) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTreeList<K, PDFTreeNode<K, V>> pdfObject = PDFTreeList.newInstance(pdfDocument, parent, keyName);
        pdfObject.add(item);
        return pdfObject;
    }

    void setKeyName(ASName keyName) {
        this.keyName = keyName;
    }

    void setParent(PDFTreeNode<K, V> parent) {
        this.mParentNode = parent;
    }

    PDFTreeNode<K, V> getParent() {
        return this.mParentNode;
    }

    ASName getKeyName() {
        return this.keyName;
    }

    @Override
    public PDFTreeNode<K, V> itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        CosDictionary cosItem = (CosDictionary)cosObject;
        if (cosItem.containsKey(this.getKeyName())) {
            return PDFTreeLeaf.getInstance(cosObject, this.getParent(), this.getKeyName());
        }
        return PDFTreeNode.getInstance(cosObject, this.getParent(), this.getKeyName());
    }

    PDFTreeList<K, V> split() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.size() <= 64) {
            return null;
        }
        CosArray newKids = this.getCosArray().splitBefore(this.size() / 2);
        return PDFTreeList.getInstance(newKids, this.getParent(), this.getKeyName());
    }

    PDFTreeList<K, V> putValue(CosScalar name, CosObject value, boolean replace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int i = 0;
        PDFTreeNode kid2 = null;
        for (PDFTreeNode kid2 : this) {
            if (kid2.inRange(name) <= 0) {
                PDFTreeNode newKid = kid2.putValue(name, value, replace);
                if (newKid != null) {
                    this.add(i + 1, newKid);
                }
                return this.split();
            }
            ++i;
        }
        PDFTreeNode newKid = kid2.putValue(name, value, replace);
        if (newKid != null) {
            this.add(newKid);
        }
        return this.split();
    }
}

