/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedIcon;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedXFAFlashAssets;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedXFAImages;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedXFAResources;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNamedDestinations;

public class PDFNameDictionary
extends PDFCosDictionary {
    private static final ASName k_JavaScript = ASName.create("JavaScript");
    private static final ASName k_Icon = ASName.create("AP");

    private PDFNameDictionary(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFNameDictionary getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFNameDictionary pdfObject = (PDFNameDictionary)PDFCosObject.getCachedInstance(cosObject, PDFNameDictionary.class);
        if (pdfObject == null) {
            pdfObject = new PDFNameDictionary(cosObject);
        }
        return pdfObject;
    }

    public static PDFNameDictionary newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFNameDictionary pdfObject = new PDFNameDictionary(cosObject);
        return pdfObject;
    }

    public PDFNamedEmbeddedFiles procureNamedEmbeddedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedEmbeddedFiles value = this.getNamedEmbeddedFiles();
        if (value == null) {
            value = PDFNamedEmbeddedFiles.newInstance(this.getPDFDocument());
            this.setNamedEmbeddedFiles(value);
        }
        return value;
    }

    public PDFNamedEmbeddedFiles getNamedEmbeddedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedEmbeddedFiles.getInstance(this.getDictionaryCosObjectValue(ASName.k_EmbeddedFiles));
    }

    public void setNamedEmbeddedFiles(PDFNamedEmbeddedFiles nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_EmbeddedFiles, nameTree);
    }

    public PDFNamedDestinations getNamedDestinations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedDestinations.getInstance(this.getDictionaryCosObjectValue(ASName.k_Dests));
    }

    public PDFNamedDestinations procureNamedDestinations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedDestinations destTree = this.getNamedDestinations();
        if (destTree == null) {
            destTree = PDFNamedDestinations.newInstance(this.getPDFDocument());
            this.setNamedDestinations(destTree);
        }
        return destTree;
    }

    public PDFNamedIcon procureNamedIcons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedIcon destTree = this.getNamedIcons();
        if (destTree == null) {
            destTree = PDFNamedIcon.newInstance(this.getPDFDocument());
            this.setNamedIcons(destTree);
        }
        return destTree;
    }

    public void setNamedDestinations(PDFNamedDestinations nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Dests, nameTree);
    }

    public PDFNamedTemplates getNamedTemplates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedTemplates.getInstance(this.getDictionaryCosObjectValue(ASName.k_Templates));
    }

    public void setNamedTemplates(PDFNamedTemplates nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Templates, nameTree);
    }

    public PDFNamedTemplates procureNamedTemplates() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedTemplates templates = this.getNamedTemplates();
        if (templates == null) {
            templates = PDFNamedTemplates.newInstance(this.getPDFDocument());
            this.setNamedTemplates(templates);
        }
        return templates;
    }

    public PDFNamedPages getNamedPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedPages.getInstance(this.getDictionaryCosObjectValue(ASName.k_Pages));
    }

    public void setNamedPages(PDFNamedPages nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Pages, nameTree);
    }

    public PDFNamedPages procureNamedPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedPages pages = this.getNamedPages();
        if (pages == null) {
            pages = PDFNamedPages.newInstance(this.getPDFDocument());
            this.setNamedPages(pages);
        }
        return pages;
    }

    public PDFNamedJavaScripts getNamedJavaScripts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedJavaScripts.getInstance(this.getDictionaryCosObjectValue(k_JavaScript));
    }

    public PDFNamedIcon getNamedIcons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedIcon.getInstance(this.getDictionaryCosObjectValue(k_Icon));
    }

    public PDFNamedJavaScripts procureNamedJavaScripts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedJavaScripts javaScripts = this.getNamedJavaScripts();
        if (javaScripts == null) {
            javaScripts = PDFNamedJavaScripts.newInstance(this.getPDFDocument());
            this.setNamedJavaScripts(javaScripts);
        }
        return javaScripts;
    }

    public void setNamedJavaScripts(PDFNamedJavaScripts nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_JavaScript, nameTree);
    }

    public void setNamedIcons(PDFNamedIcon nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_Icon, nameTree);
    }

    public void removeNamedEmbeddedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = this.getCosDictionary();
        if (cosDict != null) {
            cosDict.remove(ASName.k_EmbeddedFiles);
        }
    }

    public void removeNamedJavaScripts() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = this.getCosDictionary();
        if (cosDict != null) {
            cosDict.remove(k_JavaScript);
        }
    }

    public PDFNamedXFAResources procureNamedXFAResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNamedXFAResources xfaResources = this.getNamedXFAResources();
        if (xfaResources == null) {
            xfaResources = PDFNamedXFAResources.newInstance(this.getPDFDocument());
            this.setNamedXFAResources(xfaResources);
        }
        return xfaResources;
    }

    public PDFNamedXFAResources getNamedXFAResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedXFAResources.getInstance(this.getDictionaryCosObjectValue(ASName.k_XFAResources));
    }

    public void setNamedXFAResources(PDFNamedXFAResources nameTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_XFAResources, nameTree);
    }

    public void removeNamedXFAResources() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosDict = this.getCosDictionary();
        if (cosDict != null) {
            cosDict.remove(ASName.k_XFAResources);
        }
    }

    public PDFNamedXFAImages getNamedXFAImages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedXFAImages.getInstance(this.getDictionaryCosObjectValue(ASName.k_XFAImages));
    }

    public void setNamedXFAImages(PDFNamedXFAImages xfaImgesDict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_XFAImages, xfaImgesDict);
    }

    public PDFNamedXFAFlashAssets getNamedXFAFlashAssets() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNamedXFAFlashAssets.getInstance(this.getDictionaryCosObjectValue(ASName.k_XFAFlashAssets));
    }

    public void setNamedXFAFlashAssets(PDFNamedXFAFlashAssets flashAssets) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_XFAFlashAssets, flashAssets);
    }
}

