/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IConditionalOperatorHandler;
import java.io.IOException;

public class ConditionalContentStreamProcessor
extends ContentStreamProcessor {
    public ConditionalContentStreamProcessor(IConditionalOperatorHandler operatorHandler) {
        this.operatorHandler = operatorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentReader reader = null;
        try {
            reader = ContentReader.newInstance(content);
            this.process(reader);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void process(ContentReader reader) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        while (reader.hasNext() && ((IConditionalOperatorHandler)this.operatorHandler).continueProcesing()) {
            Instruction instruction = reader.next();
            this.process(instruction);
        }
    }
}

