/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.PKCS7EnvelopedDataHandler;
import java.security.Provider;
import java.security.SecureRandom;

public class SecurityProvidersImpl {
    private Provider mMD5;
    private Provider mRC4;
    private Provider mAES;
    private Provider mSHA1;
    private Provider mSHA1PRNG;
    private Provider mSHA256;
    private Provider mSHA384;
    private Provider mSHA512;
    private PKCS7EnvelopedDataHandler mPKCS7Handler;
    private SecureRandom mRandomGenerator;

    protected SecurityProvidersImpl(Provider md5, Provider rc4, Provider aes, Provider sha1, Provider sha1prng, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator) {
        this.mMD5 = md5;
        this.mRC4 = rc4;
        this.mAES = aes;
        this.mSHA1 = sha1;
        this.mSHA1PRNG = sha1prng;
        this.mPKCS7Handler = pkcs7Handler;
        this.mRandomGenerator = randomGenerator;
    }

    protected SecurityProvidersImpl(Provider md5, Provider rc4, Provider aes, Provider sha1, Provider sha1prng, Provider sha256, Provider sha384, Provider sha512, PKCS7EnvelopedDataHandler pkcs7Handler, SecureRandom randomGenerator) {
        this.mMD5 = md5;
        this.mRC4 = rc4;
        this.mAES = aes;
        this.mSHA1 = sha1;
        this.mSHA1PRNG = sha1prng;
        this.mSHA256 = sha256;
        this.mSHA384 = sha384;
        this.mSHA512 = sha512;
        this.mPKCS7Handler = pkcs7Handler;
        this.mRandomGenerator = randomGenerator;
    }

    public Provider getAES() {
        return this.mAES;
    }

    public Provider getMD5() {
        return this.mMD5;
    }

    public Provider getRC4() {
        return this.mRC4;
    }

    public Provider getSHA1() {
        return this.mSHA1;
    }

    public Provider getSHA256() {
        return this.mSHA256;
    }

    public Provider getSHA384() {
        return this.mSHA384;
    }

    public Provider getSHA512() {
        return this.mSHA512;
    }

    public Provider getSHA1PRNG() {
        return this.mSHA1PRNG;
    }

    public PKCS7EnvelopedDataHandler getPKCS7EnvelopedDataHandler() {
        return this.mPKCS7Handler;
    }

    public Provider requireSHA1PRNG() throws PDFSecurityConfigurationException {
        Provider provider = this.getSHA1PRNG();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("SHA1PRNG provider is not available");
        }
        return provider;
    }

    public Provider requireMD5() throws PDFSecurityConfigurationException {
        Provider provider = this.getMD5();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("MD5 provider is not available");
        }
        return provider;
    }

    public Provider requireRC4() throws PDFSecurityConfigurationException {
        Provider provider = this.getRC4();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("RC4 provider is not available");
        }
        return provider;
    }

    public Provider requireAES() throws PDFSecurityConfigurationException {
        Provider provider = this.getAES();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("AES provider is not available");
        }
        return provider;
    }

    public Provider requireSHA1() throws PDFSecurityConfigurationException {
        Provider provider = this.getSHA1();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("SHA1 provider is not available");
        }
        return provider;
    }

    public Provider requireSHA256() throws PDFSecurityConfigurationException {
        Provider provider = this.getSHA256();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("SHA256 provider is not available");
        }
        return provider;
    }

    public Provider requireSHA384() throws PDFSecurityConfigurationException {
        Provider provider = this.getSHA384();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("SHA384 provider is not available");
        }
        return provider;
    }

    public Provider requireSHA512() throws PDFSecurityConfigurationException {
        Provider provider = this.getSHA512();
        if (provider == null) {
            throw new PDFSecurityConfigurationException("SHA512 provider is not available");
        }
        return provider;
    }

    public PKCS7EnvelopedDataHandler requirePKCS7EnvelopedDataHandler() throws PDFSecurityConfigurationException {
        PKCS7EnvelopedDataHandler pkc7Handler = this.getPKCS7EnvelopedDataHandler();
        if (pkc7Handler == null) {
            throw new PDFSecurityConfigurationException("PKCS7EnvelopedDataHandler provider is not available");
        }
        return pkc7Handler;
    }

    public SecureRandom getRandomGenerator() {
        return this.mRandomGenerator;
    }

    public SecureRandom requireRandomGenerator() throws PDFSecurityConfigurationException {
        SecureRandom randomGenerator = this.getRandomGenerator();
        if (randomGenerator == null) {
            throw new PDFSecurityConfigurationException("SecureRandom generator is not available");
        }
        return randomGenerator;
    }
}

