/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class JPXInputStream {
    public static InputStream getJPXInputStream(InputStream in) throws PDFCosParseException, IOException {
        BufferedImage bufImage = ImageIO.read(in);
        byte[] outBuf = null;
        switch (bufImage.getRaster().getDataBuffer().getDataType()) {
            case 0: {
                outBuf = ((DataBufferByte)bufImage.getRaster().getDataBuffer()).getData();
                break;
            }
            case 1: {
                short[] buffer = ((DataBufferUShort)bufImage.getRaster().getDataBuffer()).getData();
                int index = 0;
                outBuf = new byte[buffer.length];
                for (short value : buffer) {
                    outBuf[index++] = (byte)(value >> 8);
                }
                break;
            }
            default: {
                throw new PDFCosParseException("Data Buffer Type Not Supported: " + bufImage.getRaster().getDataBuffer().getDataType());
            }
        }
        return new ByteArrayInputStream(outBuf);
    }
}

