/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class DecodeInputStream
extends FilterInputStream {
    protected boolean useInMark = false;
    protected byte[] inBuf = null;
    protected int inCount = 0;
    protected int inPos = 0;
    protected int inTotal = 0;
    protected byte[] outBuf = null;
    protected int outCount = 0;
    protected int outPos = 0;
    protected int outHeadroom = 0;
    protected int markPos = -1;
    protected int markLimit = 0;
    protected FilterParams diparams = null;
    protected IOException pendingException = null;
    protected boolean avoidOverrun = false;
    protected boolean closeSource = true;
    protected boolean pendingEOF = false;

    public DecodeInputStream(InputStream in, int inSize, int outSize, int outHeadroom, FilterParams diparams) {
        super(in);
        if (diparams == null) {
            diparams = new FilterParams();
        }
        this.diparams = diparams;
        this.outHeadroom = outHeadroom;
        this.outBuf = new byte[outSize + outHeadroom + 1];
        if (diparams.containsKey("AvoidInOverrun")) {
            this.avoidOverrun = (Boolean)diparams.get("AvoidInOverrun");
        }
        if (diparams.containsKey("CloseSource")) {
            this.closeSource = (Boolean)diparams.get("CloseSource");
        }
        if (in instanceof DecodeInputStream) {
            this.inBuf = ((DecodeInputStream)in).outBuf;
            this.useInMark = false;
        } else if (this.avoidOverrun) {
            this.useInMark = in.markSupported();
            this.inBuf = new byte[this.useInMark ? inSize : 1];
        } else {
            this.inBuf = new byte[inSize];
        }
    }

    public DecodeInputStream(InputStream in, int outHeadroom, FilterParams p) {
        this(in, 2048, 2048, outHeadroom, p);
    }

    public DecodeInputStream(InputStream in, FilterParams p) {
        this(in, 2048, 2048, 128, p);
    }

    public DecodeInputStream(InputStream in) {
        this(in, null);
    }

    public abstract void fill();

    protected void doFill() {
        if (this.pendingEOF || this.pendingException != null) {
            return;
        }
        this.makeBufferSpace();
        this.fill();
    }

    protected boolean fillInputBuffer() {
        if (this.inCount <= this.inPos) {
            if (this.pendingEOF || this.pendingException != null) {
                return false;
            }
            if (this.useInMark) {
                this.in.mark(this.inBuf.length);
            }
            try {
                if (this.in instanceof DecodeInputStream) {
                    DecodeInputStream din = (DecodeInputStream)this.in;
                    din.outPos = this.inPos;
                    din.doFill();
                    this.inBuf = din.outBuf;
                    this.inPos = din.outPos;
                    this.inCount = din.outCount;
                } else {
                    this.inPos = 0;
                    this.inTotal += this.inCount;
                    this.inCount = this.in.read(this.inBuf, this.inPos, this.inBuf.length);
                }
            }
            catch (IOException e) {
                this.pendingException = e;
                return false;
            }
            if (this.inCount <= this.inPos) {
                return false;
            }
        }
        return true;
    }

    protected void makeBufferSpace() {
        while (0 <= this.markPos && this.outBuf.length <= this.outPos + this.outHeadroom) {
            if (0 < this.markPos) {
                this.outPos -= this.markPos;
                System.arraycopy(this.outBuf, this.markPos, this.outBuf, 0, this.outPos);
                this.markPos = 0;
                continue;
            }
            long markLimitPlusHeadroom = Math.min((long)this.markLimit + (long)this.outHeadroom + 1L, Integer.MAX_VALUE);
            if (markLimitPlusHeadroom <= (long)this.outBuf.length) {
                this.markPos = -1;
                continue;
            }
            if (this.increaseBufferSize(markLimitPlusHeadroom)) continue;
            break;
        }
        if (this.markPos < 0) {
            this.outPos = 0;
        }
        this.outCount = this.outPos;
    }

    protected boolean increaseBufferSize(long markLimitPlusHeadroom) {
        int newSize = 2 * this.outBuf.length - (this.outHeadroom + 1);
        if (markLimitPlusHeadroom < (long)newSize) {
            newSize = (int)markLimitPlusHeadroom;
        }
        byte[] newOutBuf = new byte[newSize];
        System.arraycopy(this.outBuf, 0, newOutBuf, 0, this.outPos);
        this.outBuf = newOutBuf;
        return true;
    }

    @Override
    public int read() {
        if (this.outCount <= this.outPos) {
            this.doFill();
            if (this.outCount <= this.outPos) {
                return -1;
            }
        }
        return this.outBuf[this.outPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return (int)this.skip(len);
        }
        if (0 < len) {
            int xfer;
            if (this.outCount <= this.outPos) {
                this.doFill();
                if (this.outCount <= this.outPos) {
                    if (this.pendingException == null) {
                        return -1;
                    }
                    throw this.pendingException;
                }
            }
            if (len > (xfer = this.outCount - this.outPos)) {
                len = xfer;
            }
            System.arraycopy(this.outBuf, this.outPos, b, off, len);
            this.outPos += len;
        }
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        if (0L < len) {
            int xfer;
            if (this.outCount <= this.outPos) {
                this.doFill();
                if (this.outCount <= this.outPos) {
                    if (this.pendingException == null) {
                        return -1L;
                    }
                    throw this.pendingException;
                }
            }
            if (len > (long)(xfer = this.outCount - this.outPos)) {
                len = xfer;
            }
            this.outPos += (int)len;
        }
        return len;
    }

    @Override
    public int available() {
        if (this.outCount <= this.outPos) {
            this.doFill();
        }
        return this.outCount - this.outPos;
    }

    @Override
    public void mark(int readlimit) {
        this.markLimit = readlimit;
        this.markPos = this.outPos;
    }

    @Override
    public void reset() throws IOException {
        if (this.markPos < 0) {
            throw new FilterException("DecodeInput reset to invalid mark");
        }
        this.outPos = this.markPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public void releaseUnconsumedInput() {
        block5: {
            if (this.in instanceof DecodeInputStream) {
                ((DecodeInputStream)this.in).releaseUnconsumedInput();
                return;
            }
            try {
                do {
                    if (this.skip(Long.MAX_VALUE) >= 0L) continue;
                    this.pendingEOF = true;
                } while (!this.pendingEOF && this.pendingException == null);
                if (this.useInMark && this.inPos < this.inCount) {
                    this.in.reset();
                    this.in.skip(this.inPos);
                    this.in.mark(0);
                }
            }
            catch (IOException e) {
                if (this.pendingException != null) break block5;
                this.pendingException = e;
            }
        }
        this.inCount = 0;
        this.inPos = 0;
    }

    public int getInPos() {
        if (this.in instanceof DecodeInputStream) {
            return ((DecodeInputStream)this.in).getInPos();
        }
        return this.inTotal + this.inPos;
    }

    @Override
    public void close() throws IOException {
        if (this.avoidOverrun) {
            this.releaseUnconsumedInput();
        }
        if (this.closeSource) {
            super.close();
        }
    }
}

