/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io.stream;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.InputStreamImpl;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputByteStreamImpl
implements InputByteStream {
    protected int mark = 0;

    protected InputByteStreamImpl() {
    }

    public abstract InputByteStream slice(long var1, long var3) throws IOException;

    public InputByteStream slice() throws IOException {
        return this.slice(0L, this.length());
    }

    public abstract int read() throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public int unget() throws IOException {
        this.seek(this.getPosition() - 1L);
        int byteRead = this.read();
        this.seek(this.getPosition() - 1L);
        return byteRead;
    }

    public abstract InputByteStream seek(long var1) throws IOException;

    public abstract long getPosition() throws IOException;

    public abstract long length() throws IOException;

    public long bytesAvailable() throws IOException {
        return this.length() - this.getPosition();
    }

    public boolean eof() throws IOException {
        return this.getPosition() >= this.length();
    }

    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder message = null;
        byte[] buf = new byte[100];
        InputByteStream slice = null;
        try {
            slice = this.slice(this.getPosition(), Math.min(this.length() - this.getPosition(), (long)buf.length));
            slice.read(buf);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (slice != null) {
                    slice.close();
                }
            }
            catch (IOException e) {}
        }
        try {
            message = new StringBuilder("InputByteStream [ position = ").append(this.getPosition()).append(", limit = ").append(this.length()).append(", available = ").append(this.bytesAvailable()).append(", mark = ").append(this.mark).append(" ] ").append(new String(buf, "US-ASCII"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return message.toString();
    }

    public InputStream toInputStream() throws IOException {
        InputByteStream ibs = this.slice();
        return new InputStreamImpl(ibs);
    }
}

