/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TagSearchingOutputStream
extends FilterOutputStream {
    protected byte[] tag;
    protected Callback callback;
    protected boolean lookForTag = true;
    protected int outputTag = 0;
    protected int inTagPosition = 0;

    public TagSearchingOutputStream(OutputStream out, byte[] tag, Callback callback) throws IOException {
        super(out);
        if (tag == null || callback == null) {
            throw new IOException("Invalid parameters to the constructor.");
        }
        this.tag = (byte[])tag.clone();
        this.callback = callback;
    }

    public boolean searchForTag(boolean search) throws IOException {
        if (search == this.lookForTag) {
            return this.lookForTag;
        }
        this.writeTagBytes(true);
        this.lookForTag = search;
        return !this.lookForTag;
    }

    public boolean searchForTag() throws IOException {
        return this.lookForTag;
    }

    public int outputTag(int tagOutput) throws IOException {
        int oldTagOutput = this.outputTag;
        this.outputTag = tagOutput;
        return oldTagOutput;
    }

    public int outputTag() throws IOException {
        return this.outputTag;
    }

    public void write(int b) throws IOException {
        if (!this.checkForTag((byte)b)) {
            if (this.inTagPosition != 0) {
                this.writeTagBytes(true);
            }
            if (!this.checkForTag((byte)b)) {
                super.write(b);
            }
        }
    }

    public void close() throws IOException {
        this.writeTagBytes(true);
        super.close();
    }

    private boolean checkForTag(byte b) throws IOException {
        if (!this.lookForTag) {
            return false;
        }
        if (b == this.tag[this.inTagPosition]) {
            ++this.inTagPosition;
            if (this.inTagPosition >= this.tag.length) {
                int outputTag = this.outputTag;
                if (outputTag < 0) {
                    this.writeTagBytes(true);
                }
                this.tagFound();
                if (outputTag == 0) {
                    this.writeTagBytes(false);
                }
                if (outputTag > 0) {
                    this.writeTagBytes(true);
                }
            }
            return true;
        }
        return false;
    }

    private void writeTagBytes(boolean write) throws IOException {
        if (write && this.inTagPosition != 0) {
            this.writeBytes(this.tag, this.inTagPosition);
        }
        this.inTagPosition = 0;
    }

    private void writeBytes(byte[] b, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            super.write(b[i]);
        }
    }

    private void tagFound() throws IOException {
        this.lookForTag = this.callback.tagFound(this);
    }

    public static interface Callback {
        public boolean tagFound(TagSearchingOutputStream var1) throws IOException;
    }
}

